/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.scores;

import de.lmu.ifi.dbs.elki.evaluation.scores.ScoreEvaluation;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class PrecisionAtKEvaluation
implements ScoreEvaluation {
    public static final PrecisionAtKEvaluation RPRECISION = new PrecisionAtKEvaluation(0);
    int k;

    public PrecisionAtKEvaluation(int k) {
        this.k = k;
    }

    @Override
    public <I extends ScoreEvaluation.ScoreIter> double evaluate(ScoreEvaluation.Predicate<? super I> predicate, I iter) {
        int total;
        int cntthis;
        int k = this.k > 0 ? this.k : predicate.numPositive();
        double score = 0.0;
        for (total = 0; iter.valid() && total < k; total += cntthis) {
            int posthis = 0;
            cntthis = 0;
            do {
                if (predicate.test(iter)) {
                    ++posthis;
                }
                ++cntthis;
                iter.advance();
            } while (iter.valid() && iter.tiedToPrevious());
            if (total + cntthis > k) {
                score += (double)posthis / (double)cntthis * (double)(k - total);
                total = k;
                break;
            }
            score += (double)posthis;
        }
        return score / (double)total;
    }

    @Override
    public double expected(int pos, int all) {
        return (double)pos / (double)all;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID K_ID = new OptionID("precision.k", "k value for precision@k. Can be set to 0, to get R-precision, or the precision-recall-break-even-point.");
        int k;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter kP = (IntParameter)((IntParameter)new IntParameter(K_ID).setDefaultValue((Object)0)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
        }

        @Override
        protected PrecisionAtKEvaluation makeInstance() {
            return this.k > 0 ? new PrecisionAtKEvaluation(this.k) : RPRECISION;
        }
    }
}

