/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.scores;

import de.lmu.ifi.dbs.elki.evaluation.scores.ScoreEvaluation;
import de.lmu.ifi.dbs.elki.math.geometry.XYCurve;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class ROCEvaluation
implements ScoreEvaluation {
    public static final ROCEvaluation STATIC = new ROCEvaluation();

    @Override
    public <I extends ScoreEvaluation.ScoreIter> double evaluate(ScoreEvaluation.Predicate<? super I> predicate, I iter) {
        return ROCEvaluation.computeROCAUC(predicate, iter);
    }

    public static <I extends ScoreEvaluation.ScoreIter> XYCurve materializeROC(ScoreEvaluation.Predicate<? super I> predicate, I iter) {
        int poscnt = 0;
        int negcnt = 0;
        XYCurve curve = new XYCurve("False Positive Rate", "True Positive Rate");
        curve.add(0.0, 0.0);
        while (iter.valid()) {
            do {
                if (predicate.test(iter)) {
                    ++poscnt;
                } else {
                    ++negcnt;
                }
                iter.advance();
            } while (iter.valid() && iter.tiedToPrevious());
            curve.addAndSimplify(negcnt, poscnt);
        }
        curve.addAndSimplify(negcnt, poscnt);
        curve.rescale(1.0 / (double)negcnt, 1.0 / (double)poscnt);
        return curve;
    }

    @Override
    public double expected(int pos, int all) {
        return 0.5;
    }

    public static <I extends ScoreEvaluation.ScoreIter> double computeROCAUC(ScoreEvaluation.Predicate<? super I> predicate, I iter) {
        int poscnt = 0;
        int negcnt = 0;
        int pospre = 0;
        int negpre = 0;
        double acc = 0.0;
        while (iter.valid()) {
            do {
                if (predicate.test(iter)) {
                    ++poscnt;
                } else {
                    ++negcnt;
                }
                iter.advance();
            } while (iter.valid() && iter.tiedToPrevious());
            if (negcnt > negpre) {
                acc += (double)(poscnt + pospre) * 0.5 * (double)(negcnt - negpre);
                negpre = negcnt;
            }
            pospre = poscnt;
        }
        return (acc /= (double)((long)negcnt * (long)poscnt)) == acc ? acc : 0.5;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected ROCEvaluation makeInstance() {
            return STATIC;
        }
    }
}

