/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.scores.adapter;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.evaluation.scores.ScoreEvaluation;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.ArrayIter;

public abstract class AbstractVectorIter
implements ScoreEvaluation.ScoreIter,
ArrayIter {
    protected int[] sort;
    protected NumberVector vec;
    int pos = 0;

    public AbstractVectorIter(NumberVector vec) {
        this.vec = vec;
    }

    public int dim() {
        return this.sort[this.pos];
    }

    @Override
    public boolean valid() {
        return this.pos < this.vec.getDimensionality() && this.pos >= 0;
    }

    @Override
    public AbstractVectorIter advance() {
        ++this.pos;
        return this;
    }

    @Override
    public boolean tiedToPrevious() {
        return this.pos > 0 && Double.compare(this.vec.doubleValue(this.sort[this.pos]), this.vec.doubleValue(this.sort[this.pos - 1])) == 0;
    }

    @Override
    public int getOffset() {
        return this.pos;
    }

    @Override
    public AbstractVectorIter advance(int count) {
        this.pos += count;
        return this;
    }

    @Override
    public AbstractVectorIter retract() {
        --this.pos;
        return this;
    }

    @Override
    public AbstractVectorIter seek(int off) {
        this.pos = off;
        return this;
    }
}

