/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.scores.adapter;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.evaluation.scores.ScoreEvaluation;
import de.lmu.ifi.dbs.elki.evaluation.scores.adapter.AbstractVectorIter;

public class VectorOverThreshold
implements ScoreEvaluation.Predicate<AbstractVectorIter> {
    NumberVector vec;
    double threshold;
    int numpos;

    public VectorOverThreshold(NumberVector vec, double threshold) {
        this.vec = vec;
        this.threshold = threshold;
        this.numpos = 0;
        int l = vec.getDimensionality();
        for (int i = 0; i < l; ++i) {
            if (!(vec.doubleValue(i) > threshold)) continue;
            ++this.numpos;
        }
    }

    @Override
    public boolean test(AbstractVectorIter o) {
        return this.vec.doubleValue(o.dim()) > this.threshold;
    }

    @Override
    public int numPositive() {
        return this.numpos;
    }

    public int getDimensionality() {
        return this.vec.getDimensionality();
    }
}

