/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.similaritymatrix;

import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.PixmapResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.LinearScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class ComputeSimilarityMatrixImage<O>
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(ComputeSimilarityMatrixImage.class);
    public static final OptionID SCALING_ID = new OptionID("simmatrix.scaling", "Class to use as scaling function.");
    public static final OptionID SKIPZERO_ID = new OptionID("simmatrix.skipzero", "Skip zero values when computing the colors to increase contrast.");
    private DistanceFunction<? super O> distanceFunction;
    private ScalingFunction scaling;
    private boolean skipzero = false;

    public ComputeSimilarityMatrixImage(DistanceFunction<? super O> distanceFunction, ScalingFunction scaling, boolean skipzero) {
        this.distanceFunction = distanceFunction;
        this.scaling = scaling;
        this.skipzero = skipzero;
    }

    private SimilarityMatrix computeSimilarityMatrixImage(Relation<O> relation, DBIDIter iter) {
        ArrayModifiableDBIDs order = DBIDUtil.newArray(relation.size());
        while (iter.valid()) {
            order.add(iter);
            iter.advance();
        }
        if (order.size() != relation.size()) {
            throw new IllegalStateException("Iterable result doesn't match database size - incomplete ordering?");
        }
        DistanceQuery<O> dq = this.distanceFunction.instantiate(relation);
        int size = order.size();
        int ltotal = 2 * size;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Similarity Matrix Image", ltotal, LOG) : null;
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDArrayMIter id1 = order.iter();
        DBIDArrayMIter id2 = order.iter();
        while (id1.valid()) {
            id2.seek(id1.getOffset());
            while (id2.valid()) {
                double dist = dq.distance((DBIDRef)id1, (DBIDRef)id2);
                if (!(Double.isNaN(dist) || Double.isInfinite(dist) || this.skipzero && !(dist > 0.0))) {
                    minmax.put(dist);
                }
                id2.advance();
            }
            LOG.incrementProcessed(prog);
            id1.advance();
        }
        double zoom = minmax.getMax() - minmax.getMin();
        if (zoom > 0.0) {
            zoom = 1.0 / zoom;
        }
        LinearScaling scale = new LinearScaling(zoom, -minmax.getMin() * zoom);
        BufferedImage img = new BufferedImage(size, size, 1);
        DBIDArrayMIter id12 = order.iter();
        DBIDArrayMIter id22 = order.iter();
        for (int x = 0; x < size && id12.valid(); ++x) {
            id22.seek(id12.getOffset());
            for (int y = x; y < size && id22.valid(); ++y) {
                double ddist = dq.distance((DBIDRef)id12, (DBIDRef)id22);
                if (ddist > 0.0) {
                    ddist = scale.getScaled(ddist);
                }
                if (this.scaling != null) {
                    ddist = this.scaling.getScaled(ddist);
                }
                int dist = 0xFF & (int)(255.0 * ddist);
                int col = 0xFF000000 | dist << 16 | dist << 8 | dist;
                img.setRGB(x, y, col);
                img.setRGB(y, x, col);
                id22.advance();
            }
            LOG.incrementProcessed(prog);
            id12.advance();
        }
        LOG.ensureCompleted(prog);
        return new SimilarityMatrix(img, relation, order);
    }

    @Override
    public void processNewResult(ResultHierarchy hier, Result result) {
        Relation relation;
        Database db = ResultUtil.findDatabase(hier);
        boolean nonefound = true;
        List<OutlierResult> oresults = OutlierResult.getOutlierResults(result);
        List<OrderingResult> orderings = ResultUtil.getOrderingResults(result);
        for (OutlierResult o : oresults) {
            OrderingResult or = o.getOrdering();
            relation = db.getRelation(this.distanceFunction.getInputTypeRestriction(), new Object[0]);
            db.getHierarchy().add(or, this.computeSimilarityMatrixImage(relation, or.order(relation.getDBIDs()).iter()));
            orderings.remove(or);
            nonefound = false;
        }
        for (OrderingResult or : orderings) {
            Relation relation2 = db.getRelation(this.distanceFunction.getInputTypeRestriction(), new Object[0]);
            DBIDArrayMIter iter = or.order(relation2.getDBIDs()).iter();
            db.getHierarchy().add(or, this.computeSimilarityMatrixImage(relation2, iter));
            nonefound = false;
        }
        if (nonefound) {
            ArrayList<Database> iter = ResultUtil.filterResults(hier, Database.class);
            for (Database database : iter) {
                relation = database.getRelation(this.distanceFunction.getInputTypeRestriction(), new Object[0]);
                db.getHierarchy().add(db, this.computeSimilarityMatrixImage(relation, relation.iterDBIDs()));
            }
        }
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        private DistanceFunction<O> distanceFunction;
        private ScalingFunction scaling;
        private boolean skipzero = false;

        @Override
        protected void makeOptions(Parameterization config) {
            Flag skipzeroP;
            ObjectParameter scalingP;
            super.makeOptions(config);
            ObjectParameter distanceFunctionP = new ObjectParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class);
            if (config.grab(distanceFunctionP)) {
                this.distanceFunction = (DistanceFunction)distanceFunctionP.instantiateClass(config);
            }
            if (config.grab(scalingP = new ObjectParameter(SCALING_ID, ScalingFunction.class, true))) {
                this.scaling = (ScalingFunction)scalingP.instantiateClass(config);
            }
            if (config.grab(skipzeroP = new Flag(SKIPZERO_ID))) {
                this.skipzero = (Boolean)skipzeroP.getValue();
            }
        }

        @Override
        protected ComputeSimilarityMatrixImage<O> makeInstance() {
            return new ComputeSimilarityMatrixImage<O>(this.distanceFunction, this.scaling, this.skipzero);
        }
    }

    public static class SimilarityMatrix
    implements PixmapResult {
        private static final String IMGFILEPREFIX = "elki-pixmap-";
        Relation<?> relation;
        ArrayDBIDs ids;
        RenderedImage img;
        File imgfile = null;

        public SimilarityMatrix(RenderedImage img, Relation<?> relation, ArrayDBIDs ids) {
            this.img = img;
            this.relation = relation;
            this.ids = ids;
        }

        @Override
        public RenderedImage getImage() {
            return this.img;
        }

        @Override
        public File getAsFile() {
            if (this.imgfile == null) {
                try {
                    this.imgfile = File.createTempFile(IMGFILEPREFIX, ".png");
                    this.imgfile.deleteOnExit();
                    ImageIO.write(this.img, "PNG", this.imgfile);
                }
                catch (IOException e) {
                    LoggingUtil.exception("Could not generate OPTICS plot.", e);
                }
            }
            return this.imgfile;
        }

        public Relation<?> getRelation() {
            return this.relation;
        }

        public ArrayDBIDs getIDs() {
            return this.ids;
        }

        @Override
        public String getLongName() {
            return "Similarity Matrix";
        }

        @Override
        public String getShortName() {
            return "sim-matrix";
        }
    }
}

