/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.configurator;

import de.lmu.ifi.dbs.elki.gui.configurator.ParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.icons.StockIcon;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractParameterConfigurator<T extends Parameter<?>>
implements ParameterConfigurator {
    final T param;
    final JComponent parent;
    protected EventListenerList listenerList = new EventListenerList();

    public AbstractParameterConfigurator(T param, JComponent parent) {
        this.param = param;
        this.parent = parent;
    }

    protected void finishGridRow() {
        JLabel icon;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.weightx = 0.0;
        if (this.param.isOptional()) {
            if (this.param.isDefined() && this.param.tookDefaultValue() && !(this.param instanceof Flag)) {
                icon = new JLabel(StockIcon.getStockIcon("dialog-information"));
                icon.setToolTipText("Default value: " + this.param.getDefaultValueAsString());
            } else {
                icon = new JLabel();
                icon.setMinimumSize(new Dimension(16, 16));
            }
        } else if (!this.param.isDefined()) {
            icon = new JLabel(StockIcon.getStockIcon("dialog-error"));
            icon.setToolTipText("Missing value.");
        } else {
            icon = new JLabel();
            icon.setMinimumSize(new Dimension(16, 16));
        }
        this.parent.add((Component)icon, constraints);
    }

    @Override
    public void addParameter(Object owner, Parameter<?> param, TrackParameters track) {
        LoggingUtil.warning(this.getClass() + " does not support sub-parameters!");
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    protected void fireValueChanged() {
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener listener : (ChangeListener[])this.listenerList.getListeners(ChangeListener.class)) {
            listener.stateChanged(evt);
        }
    }

    @Override
    public void appendParameters(ListParameterization params) {
        Object val = this.getUserInput();
        if (val instanceof String && ((String)val).length() == 0) {
            val = null;
        }
        if (val != null) {
            params.addParameter(this.param.getOptionID(), val);
        }
    }

    public abstract Object getUserInput();
}

