/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.configurator;

import de.lmu.ifi.dbs.elki.gui.configurator.AbstractSingleParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.ConfiguratorPanel;
import de.lmu.ifi.dbs.elki.gui.icons.StockIcon;
import de.lmu.ifi.dbs.elki.gui.util.ClassTree;
import de.lmu.ifi.dbs.elki.gui.util.TreePopup;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClassListParameterConfigurator
extends AbstractSingleParameterConfigurator<ClassListParameter<?>>
implements ActionListener,
ChangeListener {
    final ConfiguratorPanel child;
    final JPanel panel;
    final JTextField textfield = new JTextField();
    final JButton button;
    final TreePopup popup;

    public ClassListParameterConfigurator(ClassListParameter<?> cp, JComponent parent) {
        super(cp, parent);
        this.textfield.setToolTipText(((ClassListParameter)this.param).getShortDescription());
        if (cp.isDefined() && !cp.tookDefaultValue()) {
            this.textfield.setText(cp.getValueAsString());
        }
        this.textfield.setPreferredSize(new Dimension(400, this.textfield.getPreferredSize().height));
        this.button = new JButton(StockIcon.getStockIcon("list-add"));
        this.button.setToolTipText(((ClassListParameter)this.param).getShortDescription());
        this.button.addActionListener(this);
        TreeNode root = ClassTree.build(cp.getKnownImplementations(), cp.getRestrictionClass().getPackage().getName());
        this.popup = new TreePopup(new DefaultTreeModel(root));
        this.popup.getTree().setRootVisible(false);
        this.popup.addActionListener(this);
        Icon classIcon = StockIcon.getStockIcon("go-next");
        Icon packageIcon = StockIcon.getStockIcon("package");
        TreePopup.Renderer renderer = (TreePopup.Renderer)this.popup.getTree().getCellRenderer();
        renderer.setLeafIcon(classIcon);
        renderer.setFolderIcon(packageIcon);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.textfield, "Center");
        this.panel.add((Component)this.button, "East");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        parent.add((Component)this.panel, constraints);
        this.finishGridRow();
        constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 10, 0, 0);
        this.child = new ConfiguratorPanel();
        this.child.addChangeListener(this);
        parent.add((Component)this.child, constraints);
        this.textfield.addActionListener(this);
    }

    @Override
    public void addParameter(Object owner, Parameter<?> param, TrackParameters track) {
        this.child.addParameter(owner, param, track);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button) {
            this.popup.show(this.panel);
            return;
        }
        if (e.getSource() == this.textfield) {
            this.fireValueChanged();
            return;
        }
        if (e.getSource() == this.popup) {
            String newClass;
            Object comp;
            if (e.getActionCommand() == "canceled") {
                this.popup.setVisible(false);
                this.textfield.requestFocus();
                return;
            }
            TreePath path = this.popup.getTree().getSelectionPath();
            Object object = comp = path != null ? path.getLastPathComponent() : null;
            if (comp instanceof ClassTree.ClassNode && (newClass = ((ClassTree.ClassNode)comp).getClassName()) != null && !newClass.isEmpty()) {
                String val = this.textfield.getText();
                val = !val.isEmpty() ? val + "," + newClass : newClass;
                this.textfield.setText(val);
                this.popup.setVisible(false);
                this.fireValueChanged();
            }
            return;
        }
        LoggingUtil.warning("actionPerformed triggered by unknown source: " + e.getSource());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.child) {
            this.fireValueChanged();
            return;
        }
        LoggingUtil.warning("stateChanged triggered by unknown source: " + e.getSource());
    }

    @Override
    public String getUserInput() {
        return this.textfield.getText();
    }

    @Override
    public void appendParameters(ListParameterization params) {
        super.appendParameters(params);
        this.child.appendParameters(params);
    }
}

