/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.configurator;

import de.lmu.ifi.dbs.elki.gui.configurator.ClassListParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.ClassParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.EnumParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.FileParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.FlagParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.ParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.TextParameterConfigurator;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class ConfiguratorPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private Map<Object, ParameterConfigurator> childconfig = new HashMap<Object, ParameterConfigurator>();
    private ArrayList<ParameterConfigurator> children = new ArrayList();
    protected EventListenerList listenerList = new EventListenerList();

    public ConfiguratorPanel() {
        super(new GridBagLayout());
    }

    public void addParameter(Object owner, Parameter<?> param, TrackParameters track) {
        this.setBorder(new SoftBevelBorder(1));
        ParameterConfigurator cfg = null;
        Object cur = owner;
        while (cur != null && (cfg = this.childconfig.get(cur)) == null) {
            cur = track.getParent(cur);
        }
        if (cfg != null) {
            cfg.addParameter(owner, param, track);
            return;
        }
        cfg = this.makeConfigurator(param);
        cfg.addChangeListener(this);
        this.children.add(cfg);
    }

    private ParameterConfigurator makeConfigurator(Parameter<?> param) {
        if (param instanceof Flag) {
            return new FlagParameterConfigurator((Flag)param, (JComponent)this);
        }
        if (param instanceof ClassListParameter) {
            ClassListParameterConfigurator cfg = new ClassListParameterConfigurator((ClassListParameter)param, (JComponent)this);
            this.childconfig.put(param, cfg);
            return cfg;
        }
        if (param instanceof ClassParameter) {
            ClassParameterConfigurator cfg = new ClassParameterConfigurator((ClassParameter)param, (JComponent)this);
            this.childconfig.put(param, cfg);
            return cfg;
        }
        if (param instanceof FileParameter) {
            return new FileParameterConfigurator((FileParameter)param, (JComponent)this);
        }
        if (param instanceof EnumParameter) {
            return new EnumParameterConfigurator((EnumParameter)param, (JComponent)this);
        }
        return new TextParameterConfigurator(param, (JComponent)this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof ParameterConfigurator) {
            this.fireValueChanged();
        } else {
            LoggingUtil.warning("stateChanged triggered by unknown source: " + e.getSource());
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    protected void fireValueChanged() {
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener listener : (ChangeListener[])this.listenerList.getListeners(ChangeListener.class)) {
            listener.stateChanged(evt);
        }
    }

    public void appendParameters(ListParameterization params) {
        for (ParameterConfigurator cfg : this.children) {
            cfg.appendParameters(params);
        }
    }

    public void clear() {
        this.removeAll();
        this.childconfig.clear();
        this.children.clear();
    }
}

