/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.configurator;

import de.lmu.ifi.dbs.elki.gui.configurator.AbstractSingleParameterConfigurator;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class EnumParameterConfigurator
extends AbstractSingleParameterConfigurator<EnumParameter<?>>
implements ActionListener {
    final JComboBox<String> value;

    public EnumParameterConfigurator(EnumParameter<?> cp, JComponent parent) {
        super(cp, parent);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.value = new JComboBox();
        this.value.setToolTipText(((EnumParameter)this.param).getShortDescription());
        this.value.setPrototypeDisplayValue(cp.getPossibleValues().iterator().next());
        parent.add(this.value, constraints);
        this.finishGridRow();
        if (!((EnumParameter)this.param).tookDefaultValue() && ((EnumParameter)this.param).isDefined()) {
            this.value.addItem(((EnumParameter)this.param).getValueAsString());
            this.value.setSelectedIndex(0);
        }
        if (cp.hasDefaultValue()) {
            this.value.addItem("Default: " + cp.getDefaultValueAsString());
        } else if (cp.isOptional()) {
            this.value.addItem("(optional)");
        }
        for (String s : cp.getPossibleValues()) {
            this.value.addItem(s);
        }
        this.value.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.value) {
            this.fireValueChanged();
        } else {
            LoggingUtil.warning("actionPerformed triggered by unknown source: " + e.getSource());
        }
    }

    @Override
    public String getUserInput() {
        String val = (String)this.value.getSelectedItem();
        if (val.startsWith("Default: ")) {
            return null;
        }
        if ("(optional)".equals(val)) {
            return null;
        }
        return val;
    }
}

