/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.configurator;

import de.lmu.ifi.dbs.elki.gui.configurator.AbstractSingleParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.icons.StockIcon;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileParameterConfigurator
extends AbstractSingleParameterConfigurator<FileParameter>
implements ActionListener {
    final JPanel panel;
    final JTextField textfield = new JTextField();
    final JButton button;

    public FileParameterConfigurator(FileParameter fp, JComponent parent) {
        super(fp, parent);
        this.textfield.setToolTipText(((FileParameter)this.param).getShortDescription());
        this.textfield.addActionListener(this);
        this.button = new JButton(StockIcon.getStockIcon("document-open"));
        this.button.setToolTipText(((FileParameter)this.param).getShortDescription());
        this.button.addActionListener(this);
        File f = fp.isDefined() ? (File)fp.getValue() : null;
        this.textfield.setText(f == null ? "" : f.getPath());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.textfield, "Center");
        this.panel.add((Component)this.button, "East");
        parent.add((Component)this.panel, constraints);
        this.finishGridRow();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser(new File("."));
        if (((FileParameter)this.param).isDefined()) {
            fc.setSelectedFile((File)((FileParameter)this.param).getValue());
        }
        if (e.getSource() == this.button) {
            int returnVal = fc.showOpenDialog(this.button);
            if (returnVal == 0) {
                this.textfield.setText(fc.getSelectedFile().getPath());
                this.fireValueChanged();
            }
        } else if (e.getSource() == this.textfield) {
            this.fireValueChanged();
        } else {
            LoggingUtil.warning("actionPerformed triggered by unknown source: " + e.getSource());
        }
    }

    @Override
    public String getUserInput() {
        return this.textfield.getText();
    }
}

