/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.minigui;

import de.lmu.ifi.dbs.elki.KDDTask;
import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.application.KDDCLIApplication;
import de.lmu.ifi.dbs.elki.gui.GUIUtil;
import de.lmu.ifi.dbs.elki.gui.util.DynamicParameters;
import de.lmu.ifi.dbs.elki.gui.util.LogPanel;
import de.lmu.ifi.dbs.elki.gui.util.ParameterTable;
import de.lmu.ifi.dbs.elki.gui.util.ParametersModel;
import de.lmu.ifi.dbs.elki.gui.util.SavedSettingsFile;
import de.lmu.ifi.dbs.elki.logging.CLISmartHandler;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.SerializedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import de.lmu.ifi.dbs.elki.workflow.LoggingStep;
import de.lmu.ifi.dbs.elki.workflow.OutputStep;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

@Alias(value={"mini", "minigui"})
public class MiniGUI
extends AbstractApplication {
    public static final String SAVED_SETTINGS_FILENAME = "MiniGUI-saved-settings.txt";
    public static final String NEWLINE = System.getProperty("line.separator");
    private static final Logging LOG = Logging.getLogger(MiniGUI.class);
    protected static final String ACTION_QUIT = "quit";
    JFrame frame;
    JPanel panel;
    protected LogPanel outputArea;
    protected ParameterTable parameterTable;
    protected DynamicParameters parameters;
    protected SavedSettingsFile store = new SavedSettingsFile("MiniGUI-saved-settings.txt");
    protected JComboBox<String> appCombo;
    protected JComboBox<String> savedCombo;
    protected SettingsComboboxModel savedSettingsModel;
    protected JButton runButton;
    private Class<? extends AbstractApplication> maincls = KDDCLIApplication.class;
    private JTextField commandLine;
    private String APP_PREFIX = AbstractApplication.class.getPackage().getName() + ".";

    public MiniGUI() {
        this.frame = new JFrame("ELKI MiniGUI Command Line Builder");
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int ppi = Toolkit.getDefaultToolkit().getScreenResolution();
        this.frame.setPreferredSize(new Dimension(Math.min(10 * ppi, screen.width), Math.min(10 * ppi, screen.height - 32)));
        this.frame.setDefaultCloseOperation(2);
        try {
            this.frame.setIconImage(new ImageIcon(KDDTask.class.getResource("elki-icon.png")).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.panel = new JPanel();
        this.panel.setOpaque(true);
        this.panel.setLayout(new GridBagLayout());
        this.setupAppChooser();
        this.setupParameterTable();
        this.setupLoadSaveButtons();
        this.setupCommandLine();
        this.setupLoggingArea();
        try {
            this.store.load();
            this.savedSettingsModel.update();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            LOG.exception(e);
        }
        KeyStroke key = KeyStroke.getKeyStroke(81, 2);
        this.panel.getInputMap().put(key, ACTION_QUIT);
        key = KeyStroke.getKeyStroke(87, 2);
        this.panel.getInputMap().put(key, ACTION_QUIT);
        this.panel.getActionMap().put(ACTION_QUIT, new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MiniGUI.this.frame.dispose();
            }
        });
        this.frame.setContentPane(this.panel);
        this.frame.pack();
    }

    private void setupAppChooser() {
        this.appCombo = new JComboBox();
        for (Class<?> clz : ELKIServiceRegistry.findAllImplementations(AbstractApplication.class)) {
            String nam = clz.getCanonicalName();
            if (nam == null || clz.getCanonicalName().contains("GUI")) continue;
            if (nam.startsWith(this.APP_PREFIX)) {
                nam = nam.substring(this.APP_PREFIX.length());
            }
            this.appCombo.addItem(nam);
        }
        this.appCombo.setEditable(true);
        String sel = this.maincls.getCanonicalName();
        if (sel.startsWith(this.APP_PREFIX)) {
            sel = sel.substring(this.APP_PREFIX.length());
        }
        this.appCombo.setSelectedItem(sel);
        this.appCombo.addActionListener(e -> {
            if ("comboBoxChanged".equals(e.getActionCommand())) {
                Class<AbstractApplication> clz = ELKIServiceRegistry.findImplementation(AbstractApplication.class, (String)this.appCombo.getSelectedItem());
                if (clz != null) {
                    this.maincls = clz;
                    this.updateParameterTable();
                } else {
                    LOG.warning("Main class name not found.");
                }
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.01;
        this.panel.add(this.appCombo, constraints);
    }

    private void setupParameterTable() {
        this.parameters = new DynamicParameters();
        ParametersModel parameterModel = new ParametersModel(this.parameters);
        parameterModel.addTableModelListener(e -> this.updateParameterTable());
        this.parameterTable = new ParameterTable(this.frame, parameterModel, this.parameters);
        JScrollPane scrollPane = new JScrollPane(this.parameterTable);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.panel.add((Component)scrollPane, constraints);
    }

    private void setupLoadSaveButtons() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.savedSettingsModel = new SettingsComboboxModel(this.store);
        this.savedCombo = new JComboBox<String>(this.savedSettingsModel);
        this.savedCombo.setEditable(true);
        this.savedCombo.setSelectedItem("[Saved Settings]");
        buttonPanel.add(this.savedCombo);
        JButton loadButton = new JButton("Load");
        loadButton.setMnemonic(76);
        loadButton.addActionListener(e -> {
            ArrayList<String> settings = this.store.get(this.savedSettingsModel.getSelectedItem());
            if (settings != null) {
                this.doSetParameters(settings);
            }
        });
        buttonPanel.add(loadButton);
        JButton saveButton = new JButton("Save");
        saveButton.setMnemonic(83);
        saveButton.addActionListener(e -> {
            String key = this.savedSettingsModel.getSelectedItem();
            this.parameterTable.editCellAt(-1, -1);
            ArrayList<String> list = new ArrayList<String>(this.parameters.size() * 2 + 1);
            list.add(this.maincls.getCanonicalName());
            this.parameters.serializeParameters(list);
            this.store.put(key, list);
            try {
                this.store.save();
            }
            catch (IOException e1) {
                LOG.exception(e1);
            }
            this.savedSettingsModel.update();
        });
        buttonPanel.add(saveButton);
        JButton removeButton = new JButton("Remove");
        removeButton.setMnemonic(69);
        removeButton.addActionListener(e -> {
            String key = this.savedSettingsModel.getSelectedItem();
            this.store.remove(key);
            try {
                this.store.save();
            }
            catch (IOException e1) {
                LOG.exception(e1);
            }
            this.savedCombo.setSelectedItem("[Saved Settings]");
            this.savedSettingsModel.update();
        });
        buttonPanel.add(removeButton);
        this.runButton = new JButton("Run Task");
        this.runButton.setMnemonic(82);
        this.runButton.addActionListener(e -> this.startTask());
        buttonPanel.add(this.runButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.01;
        this.panel.add((Component)buttonPanel, constraints);
    }

    private void setupCommandLine() {
        this.commandLine = new JTextField();
        this.commandLine.setEditable(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        constraints.weighty = 0.01;
        this.panel.add((Component)this.commandLine, constraints);
    }

    private void setupLoggingArea() {
        this.outputArea = new LogPanel();
        JScrollPane outputPane = new JScrollPane(this.outputArea);
        outputPane.setPreferredSize(new Dimension(800, 400));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.panel.add((Component)outputPane, constraints);
    }

    protected void updateParameterTable() {
        this.parameterTable.setEnabled(false);
        ArrayList<String> list = new ArrayList<String>(this.parameters.size() * 2 + 1);
        list.add(this.maincls.getCanonicalName());
        this.parameters.serializeParameters(list);
        this.doSetParameters(list);
        this.parameterTable.setEnabled(true);
    }

    protected void doSetParameters(List<String> params) {
        boolean hasErrors;
        Class<AbstractApplication> c;
        String first;
        if (!params.isEmpty() && !(first = params.get(0)).startsWith("-") && (c = ELKIServiceRegistry.findImplementation(AbstractApplication.class, first)) != null) {
            this.maincls = c;
            params.remove(0);
        }
        this.outputArea.clear();
        SerializedParameterization config = new SerializedParameterization(params);
        TrackParameters track = new TrackParameters(config);
        track.tryInstantiate(LoggingStep.class);
        track.tryInstantiate(this.maincls);
        config.logUnusedParameters();
        boolean bl = hasErrors = config.getErrors().size() > 0;
        if (hasErrors && !params.isEmpty()) {
            this.reportErrors(config);
        }
        this.runButton.setEnabled(!hasErrors);
        List<String> remainingParameters = config.getRemainingParameters();
        String mainnam = this.maincls.getCanonicalName();
        if (mainnam.startsWith(this.APP_PREFIX)) {
            mainnam = mainnam.substring(this.APP_PREFIX.length());
        }
        this.commandLine.setText(this.format(mainnam, params));
        this.parameterTable.removeEditor();
        this.parameterTable.setEnabled(false);
        this.parameters.updateFromTrackParameters(track);
        if (remainingParameters != null && !remainingParameters.isEmpty()) {
            DynamicParameters.RemainingOptions remo = new DynamicParameters.RemainingOptions();
            try {
                remo.setValue(FormatUtil.format(remainingParameters, " "));
            }
            catch (ParameterException e) {
                LOG.exception(e);
            }
            int bits = 6;
            this.parameters.addParameter(remo, (String)remo.getValue(), bits, 0);
        }
        config.clearErrors();
        this.parameterTable.revalidate();
        this.parameterTable.setEnabled(true);
    }

    private String format(Object ... params) {
        StringBuilder buf = new StringBuilder();
        for (Object p : params) {
            if (p instanceof String) {
                this.formatTo(buf, (String)p);
                continue;
            }
            if (p instanceof List) {
                this.formatTo(buf, (List)p);
                continue;
            }
            LOG.warning("Incorrect object type: " + p.getClass());
        }
        return buf.toString();
    }

    private void formatTo(StringBuilder buf, List<?> params) {
        for (Object p : params) {
            if (p instanceof String) {
                this.formatTo(buf, (String)p);
                continue;
            }
            LOG.warning("Incorrect object type: " + p.getClass());
        }
    }

    private void formatTo(StringBuilder buf, String s) {
        char c;
        int i;
        if (s == null || s.length() == 0) {
            return;
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        int escape = 0;
        int l = s.length();
        for (i = 0; i < l; ++i) {
            c = s.charAt(i);
            if (c == '\\') {
                escape |= 8;
                continue;
            }
            if (c <= ' ' || c >= '\u0080' || c == '<' || c == '>' || c == '|' || c == '$') {
                escape |= 1;
                continue;
            }
            if (c == '\"') {
                escape |= 2;
                continue;
            }
            if (c != '\'') continue;
            escape |= 4;
        }
        if (escape == 0) {
            buf.append(s);
        } else if ((escape & 0xA) == 0) {
            buf.append('\"').append(s).append('\"');
        } else if ((escape & 0xC) == 0) {
            buf.append('\'').append(s).append('\'');
        } else {
            buf.append('\"');
            l = s.length();
            for (i = 0; i < l; ++i) {
                c = s.charAt(i);
                if (c == '\"' || c == '\\' || c == '$') {
                    buf.append('\\');
                }
                buf.append(c);
            }
            buf.append('\"');
        }
    }

    protected void loadLatest() {
        int size = this.store.size();
        if (size > 0) {
            Pair<String, ArrayList<String>> pair = this.store.getElementAt(size - 1);
            this.savedSettingsModel.setSelectedItem(pair.first);
            this.doSetParameters((List)pair.second);
        }
    }

    protected void startTask() {
        this.parameterTable.editCellAt(-1, -1);
        this.parameterTable.setEnabled(false);
        final ArrayList<String> params = new ArrayList<String>(this.parameters.size() * 2);
        this.parameters.serializeParameters(params);
        this.parameterTable.setEnabled(true);
        this.runButton.setEnabled(false);
        this.outputArea.clear();
        SwingWorker<Void, Void> r = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                SerializedParameterization config = new SerializedParameterization(params);
                config.tryInstantiate(LoggingStep.class);
                AbstractApplication task = (AbstractApplication)config.tryInstantiate(MiniGUI.this.maincls);
                try {
                    config.logUnusedParameters();
                    if (config.getErrors().size() == 0) {
                        task.run();
                    } else {
                        MiniGUI.this.reportErrors(config);
                    }
                    LOG.debug("Task completed successfully.");
                }
                catch (Throwable e) {
                    LOG.exception("Task failed", e);
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                MiniGUI.this.runButton.setEnabled(true);
            }
        };
        r.execute();
    }

    protected void reportErrors(SerializedParameterization config) {
        StringBuilder buf = new StringBuilder(500).append("Task is not completely configured:").append(NEWLINE).append(NEWLINE);
        for (ParameterException e : config.getErrors()) {
            if (e instanceof UnspecifiedParameterException) {
                buf.append("The parameter ").append(((UnspecifiedParameterException)e).getParameterName()).append(" is required.").append(NEWLINE);
                continue;
            }
            buf.append(e.getMessage()).append(NEWLINE);
        }
        LOG.warning(buf.toString());
        config.clearErrors();
    }

    @Override
    public void run() {
        this.frame.setVisible(true);
        this.outputArea.becomeDefaultLogger();
    }

    public static void main(final String[] args) {
        try {
            Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass("de.lmu.ifi.dbs.elki.database.ids.DBIDUtil");
            clz.getMethod("newHashSet", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            StringBuilder msg = new StringBuilder(500).append("Your Java class path is incomplete.\n");
            if (e.getCause() != null) {
                for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
                    msg.append(t.toString()).append('\n');
                }
            } else {
                msg.append(e.toString()).append('\n');
            }
            msg.append("Make sure you have all the required jars on the classpath.\nOn the home page, you can find a 'elki-bundle' which should include everything.");
            JOptionPane.showMessageDialog(null, msg, "ClassPath incomplete", 0);
            return;
        }
        String toolopt = System.getenv("JAVA_TOOL_OPTION");
        if (toolopt != null && toolopt.indexOf("jayatana") >= 0) {
            String msg = "The Ubuntu JAyatana 'global menu support' hack is known to cause problems with many Java applications.\nPlease unset JAVA_TOOL_OPTION.";
            JOptionPane.showMessageDialog(null, msg, "Incompatible with JAyatana", 0);
            return;
        }
        GUIUtil.logUncaughtExceptions(LOG);
        GUIUtil.setLookAndFeel();
        OutputStep.setDefaultHandlerVisualizer();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    final MiniGUI gui = new MiniGUI();
                    gui.run();
                    List<String> params = Collections.emptyList();
                    if (args != null && args.length > 0) {
                        Class<AbstractApplication> c;
                        params = new ArrayList<String>(Arrays.asList(args));
                        if (!params.isEmpty() && (c = ELKIServiceRegistry.findImplementation(AbstractApplication.class, params.get(0))) != null) {
                            gui.maincls = c;
                            params.remove(0);
                        }
                        if (params.remove("-minigui.last")) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    gui.loadLatest();
                                }
                            });
                        }
                        if (params.remove("-minigui.autorun")) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    gui.startTask();
                                }
                            });
                        }
                    }
                    gui.doSetParameters(params);
                }
                catch (Error | Exception e) {
                    LoggingConfiguration.replaceDefaultHandler(new CLISmartHandler());
                    LOG.exception(e);
                }
            }
        });
    }

    class SettingsComboboxModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private static final long serialVersionUID = 1L;
        protected SavedSettingsFile store;
        protected String selected = null;

        public SettingsComboboxModel(SavedSettingsFile store) {
            this.store = store;
        }

        @Override
        public String getSelectedItem() {
            return this.selected;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem instanceof String) {
                this.selected = (String)anItem;
            }
        }

        @Override
        public String getElementAt(int index) {
            return (String)this.store.getElementAt((int)(this.store.size() - 1 - index)).first;
        }

        @Override
        public int getSize() {
            return this.store.size();
        }

        public void update() {
            this.fireContentsChanged(this, 0, this.getSize() + 1);
        }
    }
}

