/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.multistep;

import de.lmu.ifi.dbs.elki.KDDTask;
import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.gui.GUIUtil;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.AlgorithmTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.EvaluationTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.InputTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.LoggingTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.OutputTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.SavedSettingsTabPanel;
import de.lmu.ifi.dbs.elki.gui.util.LogPanel;
import de.lmu.ifi.dbs.elki.gui.util.SavedSettingsFile;
import de.lmu.ifi.dbs.elki.logging.CLISmartHandler;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.SerializedParameterization;
import de.lmu.ifi.dbs.elki.workflow.OutputStep;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

@Alias(value={"multi", "multigui", "multistepgui"})
public class MultiStepGUI
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(MultiStepGUI.class);
    JFrame frame = new JFrame("ELKI ExpGUI");
    protected LogPanel outputArea;
    private InputTabPanel inputTab;
    private AlgorithmTabPanel algTab;
    private EvaluationTabPanel evalTab;
    private OutputTabPanel outTab;
    private LoggingTabPanel logTab;
    private SavedSettingsTabPanel setTab;

    public MultiStepGUI() {
        this.frame.setDefaultCloseOperation(2);
        try {
            this.frame.setIconImage(new ImageIcon(KDDTask.class.getResource("elki-icon.png")).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frame.setLayout(new GridBagLayout());
        this.outputArea = new LogPanel();
        JScrollPane outputPane = new JScrollPane(this.outputArea);
        outputPane.setPreferredSize(new Dimension(800, 400));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.frame.add((Component)outputPane, constraints);
        this.outputArea.becomeDefaultLogger();
        JTabbedPane panels = new JTabbedPane();
        constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.frame.add((Component)panels, constraints);
        this.addPanels(panels);
        this.frame.pack();
    }

    private void addPanels(JTabbedPane panels) {
        SavedSettingsFile settings = new SavedSettingsFile("MiniGUI-saved-settings.txt");
        try {
            settings.load();
        }
        catch (FileNotFoundException e) {
            LOG.warning("Error loading saved settings.", e);
        }
        catch (IOException e) {
            LOG.exception(e);
        }
        this.inputTab = new InputTabPanel();
        this.algTab = new AlgorithmTabPanel(this.inputTab);
        this.evalTab = new EvaluationTabPanel(this.inputTab, this.algTab);
        this.outTab = new OutputTabPanel(this.inputTab, this.evalTab);
        this.logTab = new LoggingTabPanel();
        this.setTab = new SavedSettingsTabPanel(settings, this);
        panels.addTab("Input", this.inputTab);
        panels.addTab("Algorithm", this.algTab);
        panels.addTab("Evaluation", this.evalTab);
        panels.addTab("Output", this.outTab);
        panels.addTab("Logging", this.logTab);
        panels.addTab("Saved Settings", this.setTab);
        this.setParameters(new ListParameterization());
    }

    public void setParameters(Parameterization config) {
        this.logTab.setParameters(config);
        this.inputTab.setParameters(config);
        this.algTab.setParameters(config);
        this.evalTab.setParameters(config);
        this.outTab.setParameters(config);
    }

    public ArrayList<String> serializeParameters() {
        ListParameterization params = new ListParameterization();
        this.logTab.appendParameters(params);
        this.inputTab.appendParameters(params);
        this.algTab.appendParameters(params);
        this.evalTab.appendParameters(params);
        this.outTab.appendParameters(params);
        return params.serialize();
    }

    @Override
    public void run() {
        this.frame.setVisible(true);
        this.outputArea.becomeDefaultLogger();
    }

    public static void main(final String[] args) {
        GUIUtil.logUncaughtExceptions(LOG);
        GUIUtil.setLookAndFeel();
        OutputStep.setDefaultHandlerVisualizer();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MultiStepGUI gui = new MultiStepGUI();
                    gui.run();
                    if (args != null && args.length > 0) {
                        gui.setParameters(new SerializedParameterization(args));
                    } else {
                        gui.setParameters(new SerializedParameterization());
                    }
                }
                catch (Error | Exception e) {
                    LoggingConfiguration.replaceDefaultHandler(new CLISmartHandler());
                    LOG.exception(e);
                }
            }
        });
    }
}

