/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.multistep.panels;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.InputTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.ParameterTabPanel;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.workflow.AlgorithmStep;
import java.lang.ref.WeakReference;

public class AlgorithmTabPanel
extends ParameterTabPanel {
    private static final long serialVersionUID = 1L;
    private AlgorithmStep algorithms = null;
    private WeakReference<?> basedOnDatabase = null;
    private final InputTabPanel input;

    public AlgorithmTabPanel(InputTabPanel input) {
        this.input = input;
        input.addPanelListener(this);
    }

    @Override
    protected synchronized void configureStep(Parameterization config) {
        this.algorithms = config.tryInstantiate(AlgorithmStep.class);
        if (config.getErrors().size() > 0) {
            this.algorithms = null;
        }
        this.basedOnDatabase = null;
    }

    @Override
    protected void executeStep() {
        if (this.input.canRun() && !this.input.isComplete()) {
            this.input.execute();
        }
        if (!this.input.isComplete()) {
            throw new AbortException("Input data not available.");
        }
        Database database = this.input.getInputStep().getDatabase();
        this.algorithms.runAlgorithms(database);
        this.basedOnDatabase = new WeakReference<Database>(database);
    }

    @Override
    protected ParameterTabPanel.Status getStatus() {
        if (this.algorithms == null) {
            return ParameterTabPanel.Status.STATUS_UNCONFIGURED;
        }
        if (!this.input.canRun()) {
            return ParameterTabPanel.Status.STATUS_CONFIGURED;
        }
        this.checkDependencies();
        if (this.input.isComplete() && this.basedOnDatabase != null) {
            if (this.algorithms.getResult() == null) {
                return ParameterTabPanel.Status.STATUS_FAILED;
            }
            return ParameterTabPanel.Status.STATUS_COMPLETE;
        }
        return ParameterTabPanel.Status.STATUS_READY;
    }

    public AlgorithmStep getAlgorithmStep() {
        if (this.algorithms == null) {
            throw new AbortException("Algorithms not configured.");
        }
        return this.algorithms;
    }

    @Override
    public void panelUpdated(ParameterTabPanel o) {
        if (o == this.input) {
            this.checkDependencies();
            this.updateStatus();
        }
    }

    private void checkDependencies() {
        if (!(this.basedOnDatabase == null || this.input.isComplete() && this.basedOnDatabase.get() == this.input.getInputStep().getDatabase())) {
            this.basedOnDatabase = null;
            this.firePanelUpdated();
        }
    }
}

