/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.multistep.panels;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.AlgorithmTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.InputTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.ParameterTabPanel;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.workflow.EvaluationStep;
import java.lang.ref.WeakReference;

public class EvaluationTabPanel
extends ParameterTabPanel {
    private static final long serialVersionUID = 1L;
    private EvaluationStep evals = null;
    private WeakReference<?> basedOnResult = null;
    private final InputTabPanel input;
    private final AlgorithmTabPanel algs;

    public EvaluationTabPanel(InputTabPanel input, AlgorithmTabPanel algs) {
        this.input = input;
        this.algs = algs;
        input.addPanelListener(this);
        algs.addPanelListener(this);
    }

    @Override
    protected synchronized void configureStep(Parameterization config) {
        this.evals = config.tryInstantiate(EvaluationStep.class);
        if (config.getErrors().size() > 0) {
            this.evals = null;
        }
        this.basedOnResult = null;
    }

    @Override
    protected void executeStep() {
        if (this.input.canRun() && !this.input.isComplete()) {
            this.input.execute();
        }
        if (this.algs.canRun() && !this.algs.isComplete()) {
            this.algs.execute();
        }
        if (!this.input.isComplete() || !this.algs.isComplete()) {
            throw new AbortException("Input data not available.");
        }
        Database database = this.input.getInputStep().getDatabase();
        Result res = this.algs.getAlgorithmStep().getResult();
        this.evals.runEvaluators(database.getHierarchy(), database);
        this.basedOnResult = new WeakReference<Result>(res);
    }

    public EvaluationStep getEvaluationStep() {
        if (this.evals == null) {
            throw new AbortException("Evaluators not configured.");
        }
        return this.evals;
    }

    @Override
    protected ParameterTabPanel.Status getStatus() {
        if (this.evals == null) {
            return ParameterTabPanel.Status.STATUS_UNCONFIGURED;
        }
        if (!this.input.canRun() || !this.algs.canRun()) {
            return ParameterTabPanel.Status.STATUS_CONFIGURED;
        }
        this.checkDependencies();
        if (this.input.isComplete() && this.algs.isComplete() && this.basedOnResult != null) {
            return ParameterTabPanel.Status.STATUS_COMPLETE;
        }
        return ParameterTabPanel.Status.STATUS_READY;
    }

    @Override
    public void panelUpdated(ParameterTabPanel o) {
        if (o == this.input || o == this.algs) {
            this.checkDependencies();
            this.updateStatus();
        }
    }

    private void checkDependencies() {
        if (!(this.basedOnResult == null || this.input.isComplete() && this.algs.isComplete() && this.basedOnResult.get() == this.algs.getAlgorithmStep().getResult())) {
            this.basedOnResult = null;
            this.firePanelUpdated();
        }
    }
}

