/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.multistep.panels;

import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.EvaluationTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.InputTabPanel;
import de.lmu.ifi.dbs.elki.gui.multistep.panels.ParameterTabPanel;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.workflow.OutputStep;
import java.lang.ref.WeakReference;

public class OutputTabPanel
extends ParameterTabPanel {
    private static final long serialVersionUID = 1L;
    private OutputStep outs = null;
    private WeakReference<?> basedOnResult = null;
    private final InputTabPanel input;
    private final EvaluationTabPanel evals;

    public OutputTabPanel(InputTabPanel input, EvaluationTabPanel evals) {
        this.input = input;
        this.evals = evals;
        input.addPanelListener(this);
        evals.addPanelListener(this);
    }

    @Override
    protected synchronized void configureStep(Parameterization config) {
        this.outs = config.tryInstantiate(OutputStep.class);
        if (config.getErrors().size() > 0) {
            this.outs = null;
        }
        this.basedOnResult = null;
    }

    @Override
    protected void executeStep() {
        if (this.input.canRun() && !this.input.isComplete()) {
            this.input.execute();
        }
        if (this.evals.canRun() && !this.evals.isComplete()) {
            this.evals.execute();
        }
        if (!this.input.isComplete()) {
            throw new AbortException("Input data not available.");
        }
        if (!this.evals.isComplete()) {
            throw new AbortException("Evaluation failed.");
        }
        Database database = this.input.getInputStep().getDatabase();
        this.outs.runResultHandlers(database.getHierarchy(), database);
        Result eres = this.evals.getEvaluationStep().getResult();
        this.basedOnResult = new WeakReference<Result>(eres);
    }

    @Override
    protected ParameterTabPanel.Status getStatus() {
        if (this.outs == null) {
            return ParameterTabPanel.Status.STATUS_UNCONFIGURED;
        }
        if (!this.input.canRun() || !this.evals.canRun()) {
            return ParameterTabPanel.Status.STATUS_CONFIGURED;
        }
        this.checkDependencies();
        if (this.input.isComplete() && this.evals.isComplete() && this.basedOnResult != null) {
            return ParameterTabPanel.Status.STATUS_COMPLETE;
        }
        return ParameterTabPanel.Status.STATUS_READY;
    }

    @Override
    public void panelUpdated(ParameterTabPanel o) {
        if (o == this.input || o == this.evals) {
            this.checkDependencies();
            this.updateStatus();
        }
    }

    private void checkDependencies() {
        if (!(this.basedOnResult == null || this.input.isComplete() && this.evals.isComplete() && this.basedOnResult.get() == this.evals.getEvaluationStep().getResult())) {
            this.basedOnResult = null;
            this.firePanelUpdated();
        }
    }
}

