/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.multistep.panels;

import de.lmu.ifi.dbs.elki.gui.configurator.ConfiguratorPanel;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.UnspecifiedParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class ParameterTabPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logging LOG = Logging.getLogger(ParameterTabPanel.class);
    private final ConfiguratorPanel parameterTable;
    private final JButton runButton;
    private final JLabel statusText;

    public ParameterTabPanel() {
        this.setLayout(new GridBagLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.runButton = new JButton("Run Task");
        this.runButton.setMnemonic(82);
        this.runButton.addActionListener(e -> new Thread(this::execute).start());
        buttonPanel.add(this.runButton);
        this.statusText = new JLabel();
        buttonPanel.add(this.statusText);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.01;
        this.add((Component)buttonPanel, constraints);
        this.parameterTable = new ConfiguratorPanel();
        this.parameterTable.addChangeListener(this);
        JScrollPane scrollPane = new JScrollPane(this.parameterTable);
        constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 11;
        this.add((Component)scrollPane, constraints);
    }

    protected void updateParameterTable() {
        this.parameterTable.setEnabled(false);
        ListParameterization config = new ListParameterization();
        this.parameterTable.appendParameters(config);
        this.setParameters(config);
        if (config.getErrors().size() > 0) {
            this.reportErrors(config);
        }
        config.clearErrors();
        this.parameterTable.setEnabled(true);
    }

    public void setParameters(Parameterization config) {
        TrackParameters track = new TrackParameters(config);
        this.configureStep(track);
        this.parameterTable.setEnabled(false);
        this.parameterTable.clear();
        for (TrackedParameter pair : track.getAllParameters()) {
            this.parameterTable.addParameter(pair.getOwner(), pair.getParameter(), track);
        }
        this.parameterTable.revalidate();
        this.parameterTable.setEnabled(true);
        this.updateStatus();
        this.firePanelUpdated();
    }

    public void appendParameters(ListParameterization params) {
        this.parameterTable.appendParameters(params);
    }

    protected void reportErrors(Parameterization config) {
        StringBuilder buf = new StringBuilder();
        for (ParameterException e : config.getErrors()) {
            if (e instanceof UnspecifiedParameterException) continue;
            buf.append(e.getMessage()).append(FormatUtil.NEWLINE);
        }
        if (buf.length() > 0) {
            LOG.warning("Configuration errors:" + FormatUtil.NEWLINE + FormatUtil.NEWLINE + buf.toString());
        }
    }

    protected synchronized void execute() {
        ListParameterization config = new ListParameterization();
        this.parameterTable.appendParameters(config);
        this.runButton.setEnabled(false);
        try {
            this.configureStep(config);
            if (config.hasUnusedParameters()) {
                LOG.warning("Unused parameters: FIXME");
            }
            if (config.getErrors().size() > 0) {
                this.reportErrors(config);
            } else {
                this.executeStep();
            }
        }
        catch (Exception e) {
            LOG.exception(e);
        }
        this.updateStatus();
        this.firePanelUpdated();
    }

    protected abstract void configureStep(Parameterization var1);

    protected abstract Status getStatus();

    protected abstract void executeStep();

    public boolean canRun() {
        Status status = this.getStatus();
        return Status.STATUS_READY.equals((Object)status) || Status.STATUS_COMPLETE.equals((Object)status);
    }

    public boolean isComplete() {
        return Status.STATUS_COMPLETE.equals((Object)this.getStatus());
    }

    protected void updateStatus() {
        this.statusText.setText(this.getStatus().toString());
        this.runButton.setEnabled(this.canRun());
    }

    protected void firePanelUpdated() {
        for (ParameterTabPanel p : (ParameterTabPanel[])this.listenerList.getListeners(ParameterTabPanel.class)) {
            p.panelUpdated(this);
        }
    }

    public void addPanelListener(ParameterTabPanel o) {
        this.listenerList.add(ParameterTabPanel.class, o);
    }

    public void removePanelListener(ParameterTabPanel o) {
        this.listenerList.remove(ParameterTabPanel.class, o);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.parameterTable) {
            this.updateParameterTable();
        }
    }

    void panelUpdated(ParameterTabPanel o) {
    }

    public static enum Status {
        STATUS_UNCONFIGURED{

            public String toString() {
                return "unconfigured";
            }
        }
        ,
        STATUS_CONFIGURED{

            public String toString() {
                return "configured";
            }
        }
        ,
        STATUS_READY{

            public String toString() {
                return "ready to run";
            }
        }
        ,
        STATUS_COMPLETE{

            public String toString() {
                return "complete";
            }
        }
        ,
        STATUS_FAILED{

            public String toString() {
                return "failed";
            }
        };

    }
}

