/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.multistep.panels;

import de.lmu.ifi.dbs.elki.gui.multistep.MultiStepGUI;
import de.lmu.ifi.dbs.elki.gui.util.SavedSettingsFile;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.SerializedParameterization;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class SavedSettingsTabPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logging LOG = Logging.getLogger(SavedSettingsTabPanel.class);
    SavedSettingsFile store;
    SettingsComboboxModel savedSettingsModel;
    JComboBox<String> savedCombo;
    private MultiStepGUI gui;

    public SavedSettingsTabPanel(SavedSettingsFile store2, MultiStepGUI gui2) {
        this.store = store2;
        this.gui = gui2;
        this.setLayout(new GridBagLayout());
        this.savedSettingsModel = new SettingsComboboxModel(this.store);
        this.savedCombo = new JComboBox<String>(this.savedSettingsModel);
        this.savedCombo.setEditable(true);
        this.savedCombo.setSelectedItem("[Saved Settings]");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.01;
        this.add(this.savedCombo, constraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton loadButton = new JButton("Load");
        loadButton.setMnemonic(76);
        loadButton.addActionListener(e -> {
            String key = this.savedSettingsModel.getSelectedItem();
            ArrayList<String> settings = this.store.get(key);
            SerializedParameterization config = new SerializedParameterization(settings);
            this.gui.setParameters(config);
            config.logUnusedParameters();
            config.clearErrors();
        });
        buttonPanel.add(loadButton);
        JButton saveButton = new JButton("Save");
        saveButton.setMnemonic(83);
        saveButton.addActionListener(e -> {
            String key = this.savedSettingsModel.getSelectedItem();
            this.store.put(key, this.gui.serializeParameters());
            try {
                this.store.save();
            }
            catch (IOException e1) {
                LOG.exception(e1);
            }
            this.savedSettingsModel.update();
        });
        buttonPanel.add(saveButton);
        JButton removeButton = new JButton("Remove");
        removeButton.setMnemonic(69);
        removeButton.addActionListener(e -> {
            String key = this.savedSettingsModel.getSelectedItem();
            this.store.remove(key);
            try {
                this.store.save();
            }
            catch (IOException e1) {
                LOG.exception(e1);
            }
            this.savedCombo.setSelectedItem("[Saved Settings]");
            this.savedSettingsModel.update();
        });
        buttonPanel.add(removeButton);
        GridBagConstraints constraints2 = new GridBagConstraints();
        constraints2.fill = 2;
        constraints2.gridx = 0;
        constraints2.gridy = 1;
        constraints2.weightx = 1.0;
        constraints2.weighty = 0.01;
        this.add((Component)buttonPanel, constraints2);
    }

    class SettingsComboboxModel
    extends AbstractListModel<String>
    implements ComboBoxModel<String> {
        private static final long serialVersionUID = 1L;
        protected SavedSettingsFile store;
        protected String selected = null;

        public SettingsComboboxModel(SavedSettingsFile store) {
            this.store = store;
        }

        @Override
        public String getSelectedItem() {
            return this.selected;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem instanceof String) {
                this.selected = (String)anItem;
            }
        }

        @Override
        public String getElementAt(int index) {
            return (String)this.store.getElementAt((int)(this.store.size() - 1 - index)).first;
        }

        @Override
        public int getSize() {
            return this.store.size();
        }

        public void update() {
            this.fireContentsChanged(this, 0, this.getSize() + 1);
        }
    }
}

