/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import de.lmu.ifi.dbs.elki.utilities.ELKIServiceScanner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public final class ClassTree {
    private ClassTree() {
    }

    public static TreeNode build(List<Class<?>> choices, String rootpkg) {
        PackageNode root = new PackageNode(rootpkg, rootpkg);
        HashMap<String, PackageNode> lookup = new HashMap<String, PackageNode>();
        if (rootpkg != null) {
            lookup.put(rootpkg, root);
        }
        lookup.put("de.lmu.ifi.dbs.elki", root);
        lookup.put("", root);
        String prefix = rootpkg != null ? rootpkg + "." : null;
        Class[] choic = choices.toArray(new Class[choices.size()]);
        Arrays.sort(choic, ELKIServiceScanner.SORT_BY_PRIORITY);
        for (Class impl : choic) {
            String name = impl.getName();
            name = prefix != null && name.startsWith(prefix) ? name.substring(prefix.length()) : name;
            int plen = impl.getPackage() != null ? impl.getPackage().getName().length() + 1 : 0;
            DefaultMutableTreeNode c = new ClassNode(impl.getName().substring(plen), name);
            MutableTreeNode p = null;
            int l = name.lastIndexOf(46);
            while (p == null) {
                if (l < 0) {
                    p = root;
                    break;
                }
                String pname = name.substring(0, l);
                p = (MutableTreeNode)lookup.get(pname);
                if (p != null) break;
                l = pname.lastIndexOf(46);
                PackageNode tmp = new PackageNode(l >= 0 ? pname.substring(l + 1) : pname, pname);
                tmp.insert(c, 0);
                c = tmp;
                lookup.put(pname, tmp);
                name = pname;
            }
            p.insert(c, p.getChildCount());
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            MutableTreeNode c2;
            MutableTreeNode c = (MutableTreeNode)root.getChildAt(i);
            if (c == (c2 = ClassTree.simplifyTree(c, null))) continue;
            root.remove(i);
            root.insert(c2, i);
        }
        return root;
    }

    private static MutableTreeNode simplifyTree(MutableTreeNode cur, String prefix) {
        if (cur instanceof PackageNode) {
            PackageNode node = (PackageNode)cur;
            if (node.getChildCount() == 1) {
                String newprefix = prefix != null ? prefix + "." + (String)node.getUserObject() : (String)node.getUserObject();
                cur = ClassTree.simplifyTree((MutableTreeNode)node.getChildAt(0), newprefix);
            } else {
                if (prefix != null) {
                    node.setUserObject(prefix + "." + (String)node.getUserObject());
                }
                for (int i = 0; i < node.getChildCount(); ++i) {
                    MutableTreeNode c2;
                    MutableTreeNode c = (MutableTreeNode)node.getChildAt(i);
                    if (c == (c2 = ClassTree.simplifyTree(c, null))) continue;
                    node.remove(i);
                    node.insert(c2, i);
                }
            }
        } else if (cur instanceof ClassNode) {
            ClassNode node = (ClassNode)cur;
            if (prefix != null) {
                node.setUserObject(prefix + "." + (String)node.getUserObject());
            }
        }
        return cur;
    }

    public static class ClassNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private String clsname;

        public ClassNode(String display, String clsname) {
            super(display);
            this.clsname = clsname;
        }

        public String getClassName() {
            return this.clsname;
        }
    }

    public static class PackageNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private String pkgname;

        public PackageNode(String display, String pkgname) {
            super(display);
            this.pkgname = pkgname;
        }

        public String getPackageName() {
            return this.pkgname;
        }
    }
}

