/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import java.util.ArrayList;

public class DynamicParameters {
    public static final int BIT_INCOMPLETE = 1;
    public static final int BIT_INVALID = 2;
    public static final int BIT_SYNTAX_ERROR = 4;
    public static final int BIT_OPTIONAL = 8;
    public static final int BIT_DEFAULT_VALUE = 16;
    public static final String STRING_USE_DEFAULT = "Default: ";
    public static final String STRING_OPTIONAL = "(optional)";
    protected ArrayList<Node> parameters = new ArrayList();
    protected static OptionID REMAINING_OPTIONS_ID = new OptionID("UNUSED", "Unrecognized options.");

    public int size() {
        return this.parameters.size();
    }

    public synchronized void updateFromTrackParameters(TrackParameters track) {
        this.parameters.clear();
        for (TrackedParameter p : track.getAllParameters()) {
            Parameter<?> option = p.getParameter();
            String value = null;
            if (option.isDefined()) {
                value = option.tookDefaultValue() ? STRING_USE_DEFAULT + option.getDefaultValueAsString() : option.getValueAsString();
            }
            if (value == null) {
                value = option instanceof Flag ? "false" : "";
            }
            int bits = 0;
            if (option.isOptional()) {
                bits |= 8;
            }
            if (option.hasDefaultValue() && option.tookDefaultValue()) {
                bits |= 0x10;
            }
            if (value.length() <= 0) {
                if ((bits & 0x10) == 0 && (bits & 8) == 0) {
                    bits |= 1;
                }
            } else {
                try {
                    if (!option.tookDefaultValue() && !option.isValid(value)) {
                        bits |= 2;
                    }
                }
                catch (ParameterException e) {
                    bits |= 2;
                }
            }
            int depth = 0;
            Object pos = track.getParent(option);
            while (pos != null) {
                pos = track.getParent(pos);
                if (++depth <= 10) continue;
            }
            this.parameters.add(new Node(option, value, bits, depth));
        }
    }

    public synchronized void addParameter(Parameter<?> option, String value, int bits, int depth) {
        this.parameters.add(new Node(option, value, bits, depth));
    }

    public synchronized void serializeParameters(ArrayList<String> p) {
        for (Node t : this.parameters) {
            if (t.param == null) continue;
            if (t.param instanceof RemainingOptions) {
                for (String str : t.value.split(" ")) {
                    if (str.length() <= 0) continue;
                    p.add(str);
                }
                continue;
            }
            if (t.param instanceof Flag) {
                if (!"true".equals(t.value)) continue;
                p.add("-" + t.param.getOptionID().getName());
                continue;
            }
            if (t.value == null || t.value.length() <= 0 || t.value.startsWith(STRING_USE_DEFAULT) || STRING_OPTIONAL.equals(t.value)) continue;
            p.add("-" + t.param.getOptionID().getName());
            p.add(t.value);
        }
    }

    public Node getNode(int rowIndex) {
        return this.parameters.get(rowIndex);
    }

    public static class RemainingOptions
    extends StringParameter {
        public RemainingOptions() {
            super(REMAINING_OPTIONS_ID);
            this.setOptional(true);
        }
    }

    public class Node {
        protected Parameter<?> param;
        protected String value;
        protected int flags;
        protected int depth;

        public Node(Parameter<?> param, String value, int flags, int depth) {
            this.param = param;
            this.value = value;
            this.flags = flags;
            this.depth = depth;
        }
    }
}

