/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import de.lmu.ifi.dbs.elki.logging.ErrorFormatter;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.logging.MessageFormatter;
import de.lmu.ifi.dbs.elki.logging.progress.ProgressLogRecord;
import java.awt.Color;
import java.awt.EventQueue;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class LogPane
extends JTextPane {
    private static final long serialVersionUID = 1L;
    protected Style baseStyle;
    protected Style msgStyle;
    protected Style dbgStyle;
    protected Style errStyle;
    private Formatter msgformat = new MessageFormatter();
    private Formatter debugformat = new ErrorFormatter();
    private Formatter errformat = new ErrorFormatter();
    private int lastNewlinePos = 0;

    public LogPane() {
        this.baseStyle = this.getStyledDocument().addStyle(null, null);
        this.msgStyle = this.getStyledDocument().addStyle("msg", this.baseStyle);
        this.errStyle = this.getStyledDocument().addStyle("err", this.baseStyle);
        this.errStyle.addAttribute(StyleConstants.Foreground, Color.RED);
        this.dbgStyle = this.getStyledDocument().addStyle("err", this.baseStyle);
        this.dbgStyle.addAttribute(StyleConstants.Foreground, Color.BLUE);
    }

    public void publish(String message, Level level) {
        try {
            this.publish(new LogRecord(level, message));
        }
        catch (BadLocationException e) {
            throw new RuntimeException("Error writing a log-like message.", e);
        }
    }

    protected synchronized void publish(LogRecord record) throws BadLocationException {
        Style style;
        Formatter fmt;
        if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
            fmt = this.errformat;
            style = this.errStyle;
        } else if (record.getLevel().intValue() <= Level.FINE.intValue()) {
            fmt = this.debugformat;
            style = this.dbgStyle;
        } else {
            fmt = this.msgformat;
            style = this.msgStyle;
        }
        String m = fmt.format(record);
        StyledDocument doc = this.getStyledDocument();
        if (record instanceof ProgressLogRecord) {
            if (this.lastNewlinePos < doc.getLength()) {
                doc.remove(this.lastNewlinePos, doc.getLength() - this.lastNewlinePos);
            }
        } else if (this.lastNewlinePos < doc.getLength()) {
            doc.insertString(doc.getLength(), "\n", style);
            this.lastNewlinePos = doc.getLength();
        }
        int tail = this.tailingNonNewline(m, 0, m.length());
        int headlen = m.length() - tail;
        if (headlen > 0) {
            String pre = m.substring(0, headlen);
            doc.insertString(doc.getLength(), pre, style);
        }
        this.lastNewlinePos = doc.getLength();
        if (tail > 0) {
            String post = m.substring(m.length() - tail);
            doc.insertString(this.lastNewlinePos, post, style);
        }
    }

    private int tailingNonNewline(String str, int off, int len) {
        for (int cnt = 0; cnt < len; ++cnt) {
            int pos = off + (len - 1) - cnt;
            if (str.charAt(pos) != '\n') continue;
            return cnt;
        }
        return len;
    }

    public void clear() {
        this.setText("");
        this.lastNewlinePos = 0;
    }

    public void becomeDefaultLogger() {
        LoggingConfiguration.replaceDefaultHandler(new LogPaneHandler());
    }

    private class LogPaneHandler
    extends Handler {
        protected LogPaneHandler() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord record) {
            if (EventQueue.isDispatchThread()) {
                try {
                    LogPane.this.publish(record);
                }
                catch (Exception e) {
                    this.reportError("Error printing output log message.", e, 0);
                }
            } else {
                SwingUtilities.invokeLater(() -> {
                    try {
                        LogPane.this.publish(record);
                    }
                    catch (Exception e) {
                        this.reportError("Error printing output log message.", e, 0);
                    }
                });
            }
        }
    }
}

