/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import de.lmu.ifi.dbs.elki.gui.util.LogPane;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.MutableProgress;
import de.lmu.ifi.dbs.elki.logging.progress.Progress;
import de.lmu.ifi.dbs.elki.logging.progress.ProgressLogRecord;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class LogPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected LogPane logpane = new LogPane();
    protected HashMap<Progress, JProgressBar> pbarmap = new HashMap();

    public LogPanel() {
        super.setLayout(new BoxLayout(this, 1));
        JScrollPane outputPane = new JScrollPane(this.logpane);
        outputPane.setPreferredSize(new Dimension(200, 200));
        super.add(outputPane);
    }

    public void becomeDefaultLogger() {
        LoggingConfiguration.replaceDefaultHandler(new LogPanelHandler());
    }

    protected void publish(LogRecord record) {
        if (record instanceof ProgressLogRecord) {
            ProgressLogRecord preg = (ProgressLogRecord)record;
            Progress prog = preg.getProgress();
            JProgressBar pbar = this.getOrCreateProgressBar(prog);
            this.updateProgressBar(prog, pbar);
            if (prog.isComplete()) {
                this.removeProgressBar(prog, pbar);
            }
            if (prog.isComplete() || prog instanceof StepProgress) {
                this.publishTextRecord(record);
            }
        } else {
            this.publishTextRecord(record);
        }
    }

    private void publishTextRecord(LogRecord record) {
        try {
            this.logpane.publish(record);
        }
        catch (Exception e) {
            throw new RuntimeException("Error writing a log-like message.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JProgressBar getOrCreateProgressBar(Progress prog) {
        JProgressBar pbar = this.pbarmap.get(prog);
        if (pbar == null) {
            HashMap<Progress, JProgressBar> hashMap = this.pbarmap;
            synchronized (hashMap) {
                if (prog instanceof FiniteProgress) {
                    pbar = new JProgressBar(0, ((FiniteProgress)prog).getTotal());
                    pbar.setStringPainted(true);
                } else if (prog instanceof IndefiniteProgress) {
                    pbar = new JProgressBar();
                    pbar.setIndeterminate(true);
                    pbar.setStringPainted(true);
                } else if (prog instanceof MutableProgress) {
                    pbar = new JProgressBar(0, ((MutableProgress)prog).getTotal());
                    pbar.setStringPainted(true);
                } else {
                    throw new RuntimeException("Unsupported progress record");
                }
                this.pbarmap.put(prog, pbar);
                JProgressBar pbar2 = pbar;
                SwingUtilities.invokeLater(() -> this.addProgressBar(pbar2));
            }
        }
        return pbar;
    }

    private void updateProgressBar(Progress prog, JProgressBar pbar) {
        if (prog instanceof FiniteProgress) {
            pbar.setValue(((FiniteProgress)prog).getProcessed());
            pbar.setString(((FiniteProgress)prog).toString());
        } else if (prog instanceof IndefiniteProgress) {
            pbar.setValue(((IndefiniteProgress)prog).getProcessed());
            pbar.setString(((IndefiniteProgress)prog).toString());
        } else if (prog instanceof MutableProgress) {
            pbar.setValue(((MutableProgress)prog).getProcessed());
            pbar.setMaximum(((MutableProgress)prog).getProcessed());
            pbar.setString(((MutableProgress)prog).toString());
        } else {
            throw new RuntimeException("Unsupported progress record");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProgressBar(Progress prog, JProgressBar pbar) {
        HashMap<Progress, JProgressBar> hashMap = this.pbarmap;
        synchronized (hashMap) {
            this.pbarmap.remove(prog);
            SwingUtilities.invokeLater(() -> this.removeProgressBar(pbar));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.logpane.clear();
        HashMap<Progress, JProgressBar> hashMap = this.pbarmap;
        synchronized (hashMap) {
            for (Map.Entry<Progress, JProgressBar> ent : this.pbarmap.entrySet()) {
                super.remove(ent.getValue());
                this.pbarmap.remove(ent.getKey());
            }
        }
    }

    protected void addProgressBar(JProgressBar pbar) {
        super.add(pbar);
        super.revalidate();
    }

    protected void removeProgressBar(JProgressBar pbar) {
        super.remove(pbar);
        super.revalidate();
    }

    private class LogPanelHandler
    extends Handler {
        protected LogPanelHandler() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord record) {
            LogPanel.this.publish(record);
        }
    }
}

