/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import de.lmu.ifi.dbs.elki.gui.icons.StockIcon;
import de.lmu.ifi.dbs.elki.gui.util.ClassTree;
import de.lmu.ifi.dbs.elki.gui.util.DynamicParameters;
import de.lmu.ifi.dbs.elki.gui.util.ParametersModel;
import de.lmu.ifi.dbs.elki.gui.util.TreePopup;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ParameterTable
extends JTable {
    private static final long serialVersionUID = 1L;
    static final Color COLOR_INCOMPLETE = new Color(0xFFCF9F);
    static final Color COLOR_SYNTAX_ERROR = new Color(0xFFAFAF);
    static final Color COLOR_OPTIONAL = new Color(0xEFFFEF);
    static final Color COLOR_DEFAULT_VALUE = new Color(0xEFEFEF);
    protected Frame frame;
    protected DynamicParameters parameters;

    public ParameterTable(Frame frame, ParametersModel pm, DynamicParameters parameters) {
        super(pm);
        this.frame = frame;
        this.parameters = parameters;
        this.setFillsViewportHeight(true);
        ColorfulRenderer colorfulRenderer = new ColorfulRenderer();
        this.setDefaultRenderer(Parameter.class, colorfulRenderer);
        this.setDefaultRenderer(String.class, colorfulRenderer);
        AdjustingEditor editor = new AdjustingEditor();
        this.setDefaultEditor(String.class, editor);
        this.setAutoResizeMode(4);
        TableColumn col1 = this.getColumnModel().getColumn(0);
        int ppi = Toolkit.getDefaultToolkit().getScreenResolution();
        col1.setPreferredWidth(2 * ppi);
        TableColumn col2 = this.getColumnModel().getColumn(1);
        col2.setPreferredWidth(8 * ppi);
        this.addKeyListener(new Handler());
        this.setRowHeight(this.getRowHeight() + (int)((double)ppi * 0.05));
    }

    private class DispatchingPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected JComponent component;

        public DispatchingPanel(JComponent component) {
            this.component = component;
            this.setRequestFocusEnabled(true);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.component.requestFocus();
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            InputMap map = this.component.getInputMap(condition);
            ActionMap am = this.component.getActionMap();
            if (map != null && am != null && this.isEnabled()) {
                Action action;
                Object binding = map.get(ks);
                Action action2 = action = binding == null ? null : am.get(binding);
                if (action != null) {
                    return SwingUtilities.notifyAction(action, ks, e, this.component, e.getModifiers());
                }
            }
            return false;
        }
    }

    private class AdjustingEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private final DropdownEditor dropdownEditor;
        private final DefaultCellEditor plaintextEditor;
        private final ClassListEditor classListEditor;
        private final FileNameEditor fileNameEditor;
        private TableCellEditor activeEditor;

        public AdjustingEditor() {
            JComboBox<String> combobox = new JComboBox<String>();
            combobox.setEditable(true);
            this.dropdownEditor = new DropdownEditor(combobox);
            JTextField tf = new JTextField();
            tf.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.plaintextEditor = new DefaultCellEditor(tf);
            this.classListEditor = new ClassListEditor();
            this.fileNameEditor = new FileNameEditor();
        }

        @Override
        public Object getCellEditorValue() {
            if (this.activeEditor == null) {
                return null;
            }
            return this.activeEditor.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String s;
            if (value instanceof String && (s = (String)value).startsWith("Default: ")) {
                value = s.substring("Default: ".length());
            }
            if (row < ParameterTable.this.parameters.size()) {
                Parameter<?> option = ParameterTable.this.parameters.getNode((int)row).param;
                if (option instanceof Flag) {
                    this.activeEditor = this.dropdownEditor;
                    return this.dropdownEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                }
                if (option instanceof ClassListParameter) {
                    this.activeEditor = this.classListEditor;
                    return this.classListEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                }
                if (option instanceof ClassParameter) {
                    this.activeEditor = this.classListEditor;
                    return this.classListEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                }
                if (option instanceof FileParameter) {
                    this.activeEditor = this.fileNameEditor;
                    return this.fileNameEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                }
                if (option instanceof EnumParameter) {
                    this.activeEditor = this.dropdownEditor;
                    return this.dropdownEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
                }
            }
            this.activeEditor = this.plaintextEditor;
            return this.plaintextEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private class ClassListEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        final JPanel panel;
        final JTextField textfield = new JTextField();
        final JButton button = new JButton("+");
        final TreePopup popup;
        private TreeModel model;
        private Parameter<?> option;

        public ClassListEditor() {
            this.textfield.addKeyListener(this);
            this.button.addActionListener(this);
            this.model = new DefaultTreeModel(new DefaultMutableTreeNode());
            this.popup = new TreePopup(this.model);
            this.popup.getTree().setRootVisible(false);
            this.popup.addActionListener(this);
            Icon classIcon = StockIcon.getStockIcon("go-next");
            Icon packageIcon = StockIcon.getStockIcon("package");
            TreePopup.Renderer renderer = (TreePopup.Renderer)this.popup.getTree().getCellRenderer();
            renderer.setLeafIcon(classIcon);
            renderer.setFolderIcon(packageIcon);
            this.panel = new DispatchingPanel(this.textfield);
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.textfield, "Center");
            this.panel.add((Component)this.button, "East");
            this.textfield.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.button) {
                this.popup.show(this.panel);
                return;
            }
            if (e.getSource() == this.popup) {
                String newClass;
                Object comp;
                if (e.getActionCommand() == "canceled") {
                    this.popup.setVisible(false);
                    this.textfield.requestFocus();
                    return;
                }
                TreePath path = this.popup.getTree().getSelectionPath();
                Object object = comp = path != null ? path.getLastPathComponent() : null;
                if (comp instanceof ClassTree.ClassNode && (newClass = ((ClassTree.ClassNode)comp).getClassName()) != null && !newClass.isEmpty()) {
                    if (this.option instanceof ClassListParameter) {
                        String val = this.textfield.getText();
                        if (val.equals("(optional)") || val.startsWith("Default: ")) {
                            val = "";
                        }
                        val = val.isEmpty() ? newClass : val + "," + newClass;
                        this.textfield.setText(val);
                    } else {
                        this.textfield.setText(newClass);
                    }
                    this.popup.setVisible(false);
                    this.fireEditingStopped();
                    this.textfield.requestFocus();
                }
                return;
            }
            LoggingUtil.warning("Unrecognized action event in ClassListEditor: " + e);
        }

        @Override
        public Object getCellEditorValue() {
            return this.textfield.getText();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!((e.getModifiersEx() & 0x80) == 0 || e.getKeyCode() != 32 && e.getKeyCode() != 10 && e.getKeyCode() != 40 && e.getKeyCode() != 225 || this.popup.isVisible())) {
                this.popup.show(this.panel);
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (row < ParameterTable.this.parameters.size()) {
                TreeNode root;
                this.option = ParameterTable.this.parameters.getNode((int)row).param;
                if (this.option instanceof ClassListParameter) {
                    ClassListParameter cp = (ClassListParameter)this.option;
                    root = ClassTree.build(cp.getKnownImplementations(), cp.getRestrictionClass().getPackage().getName());
                    this.button.setText("+");
                } else if (this.option instanceof ClassParameter) {
                    ClassParameter cp = (ClassParameter)this.option;
                    root = ClassTree.build(cp.getKnownImplementations(), cp.getRestrictionClass().getPackage().getName());
                    this.button.setText("v");
                } else {
                    root = new DefaultMutableTreeNode();
                }
                if (this.option.isDefined()) {
                    if (this.option.tookDefaultValue()) {
                        this.textfield.setText("Default: " + this.option.getDefaultValueAsString());
                    } else {
                        this.textfield.setText(this.option.getValueAsString());
                    }
                } else {
                    this.textfield.setText("");
                }
                this.popup.getTree().setModel(new DefaultTreeModel(root));
            }
            return this.panel;
        }
    }

    private class FileNameEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        final JPanel panel;
        final JTextField textfield = new JTextField();
        final JButton button = new JButton("...");
        int mode = 0;
        String defaultpath = new File(".").getAbsolutePath();

        public FileNameEditor() {
            this.button.addActionListener(this);
            this.panel = new DispatchingPanel(this.textfield);
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.textfield, "Center");
            this.panel.add((Component)this.button, "East");
            this.textfield.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.textfield.addKeyListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileDialog fc = new FileDialog(ParameterTable.this.frame);
            fc.setDirectory(this.defaultpath);
            fc.setMode(this.mode);
            String curr = this.textfield.getText();
            if (curr != null && curr.length() > 0) {
                fc.setFile(curr);
            }
            fc.setVisible(true);
            String filename = fc.getFile();
            if (filename != null) {
                this.textfield.setText(new File(fc.getDirectory(), filename).getPath());
            }
            fc.setVisible(false);
            fc.dispose();
            this.textfield.requestFocus();
            this.fireEditingStopped();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if ((e.getModifiersEx() & 0x80) != 0 && (e.getKeyCode() == 32 || e.getKeyCode() == 10 || e.getKeyCode() == 40 || e.getKeyCode() == 225)) {
                e.consume();
                this.actionPerformed(new ActionEvent(e.getSource(), 1001, "assist"));
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public Object getCellEditorValue() {
            return this.textfield.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Parameter<?> option;
            if (row < ParameterTable.this.parameters.size() && (option = ParameterTable.this.parameters.getNode((int)row).param) instanceof FileParameter) {
                FileParameter fp = (FileParameter)option;
                this.mode = FileParameter.FileType.INPUT_FILE.equals((Object)fp.getFileType()) ? 0 : 1;
                this.textfield.setText(fp.isDefined() ? ((File)fp.getValue()).getPath() : "");
            }
            this.textfield.requestFocus();
            return this.panel;
        }
    }

    private class DropdownEditor
    extends DefaultCellEditor
    implements KeyListener {
        private static final long serialVersionUID = 1L;
        final JPanel panel;
        private final JComboBox<String> comboBox;

        public DropdownEditor(JComboBox<String> comboBox) {
            super(comboBox);
            this.comboBox = comboBox;
            this.panel = new DispatchingPanel((JComponent)comboBox.getEditor().getEditorComponent());
            this.panel.setLayout(new BorderLayout());
            this.panel.add(comboBox, "Center");
            comboBox.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!((e.getModifiersEx() & 0x80) == 0 || e.getKeyCode() != 32 && e.getKeyCode() != 10 && e.getKeyCode() != 40 && e.getKeyCode() != 225 || this.comboBox.isPopupVisible())) {
                this.comboBox.showPopup();
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.comboBox.removeAllItems();
            Object val = table.getValueAt(row, column);
            if (val != null && val instanceof String) {
                String sval = (String)val;
                if (sval.equals("(optional)")) {
                    sval = "";
                }
                if (sval.startsWith("Default: ")) {
                    sval = "";
                }
                if (sval != "") {
                    this.comboBox.addItem(sval);
                    this.comboBox.setSelectedIndex(0);
                }
            }
            if (row < ParameterTable.this.parameters.size()) {
                Parameter<?> option = ParameterTable.this.parameters.getNode((int)row).param;
                if (option instanceof Flag) {
                    if (!"true".equals(val)) {
                        this.comboBox.addItem("true");
                    }
                    if (!"false".equals(val)) {
                        this.comboBox.addItem("false");
                    }
                } else if (option instanceof EnumParameter) {
                    EnumParameter ep = (EnumParameter)option;
                    for (String s : ep.getPossibleValues()) {
                        if (ep.hasDefaultValue() && ep.getDefaultValueAsString().equals(s)) {
                            this.comboBox.addItem("Default: " + s);
                            continue;
                        }
                        if (s.equals(val)) continue;
                        this.comboBox.addItem(s);
                    }
                }
            }
            return this.panel;
        }
    }

    private class ColorfulRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public void setValue(Object value) {
            if (value instanceof String) {
                this.setText((String)value);
                this.setToolTipText(null);
                return;
            }
            if (value instanceof DynamicParameters.Node) {
                Parameter<?> o = ((DynamicParameters.Node)value).param;
                StringBuilder buf = new StringBuilder();
                for (int i = 1; i < ((DynamicParameters.Node)value).depth; ++i) {
                    buf.append(' ');
                }
                buf.append(o.getOptionID().getName());
                this.setText(buf.toString());
                this.setToolTipText(o.getOptionID().getDescription());
                return;
            }
            this.setText("");
            this.setToolTipText(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!hasFocus && row < ParameterTable.this.parameters.size()) {
                int flags = ParameterTable.this.parameters.getNode((int)row).flags;
                c.setForeground(Color.BLACK);
                if ((flags & 2) != 0) {
                    c.setBackground(COLOR_SYNTAX_ERROR);
                } else if ((flags & 4) != 0) {
                    c.setBackground(COLOR_SYNTAX_ERROR);
                } else if ((flags & 1) != 0) {
                    c.setBackground(COLOR_INCOMPLETE);
                } else if ((flags & 0x10) != 0) {
                    c.setBackground(COLOR_DEFAULT_VALUE);
                } else if ((flags & 8) != 0) {
                    c.setBackground(COLOR_OPTIONAL);
                } else {
                    c.setBackground(null);
                }
            }
            return c;
        }
    }

    protected class Handler
    implements KeyListener {
        protected Handler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            ParameterTable parent;
            if (!((e.getModifiersEx() & 0x80) == 0 || e.getKeyCode() != 32 && e.getKeyCode() != 10 && e.getKeyCode() != 40 && e.getKeyCode() != 225 || (parent = ParameterTable.this).isEditing())) {
                int leadRow = parent.getSelectionModel().getLeadSelectionIndex();
                int leadColumn = parent.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                parent.editCellAt(leadRow, leadColumn);
                Component editorComponent = ParameterTable.this.getEditorComponent();
                if (editorComponent instanceof DispatchingPanel) {
                    KeyListener[] l;
                    for (KeyListener li : l = ((DispatchingPanel)editorComponent).component.getKeyListeners()) {
                        li.keyPressed(e);
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

