/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import de.lmu.ifi.dbs.elki.gui.util.DynamicParameters;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import javax.swing.table.AbstractTableModel;

public class ParametersModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Logging LOG = Logging.getLogger(ParametersModel.class);
    private DynamicParameters parameters;
    public static final String[] columns = new String[]{"Parameter", "Value"};

    public ParametersModel(DynamicParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public int getRowCount() {
        return this.parameters.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.parameters.size()) {
            DynamicParameters.Node node = this.parameters.getNode(rowIndex);
            if (columnIndex == 0) {
                return node;
            }
            if (columnIndex == 1) {
                String ret = node.value;
                if (ret == null) {
                    ret = "";
                }
                return ret;
            }
            return "";
        }
        return "";
    }

    @Override
    public String getColumnName(int column) {
        return columns[column];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Parameter.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1 || rowIndex > this.parameters.size();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (value instanceof String) {
            String s = (String)value;
            if (columnIndex == 1) {
                if (s.equals(this.parameters.getNode((int)rowIndex).value)) {
                    return;
                }
                if (("Default: " + s).equals(this.parameters.getNode((int)rowIndex).value)) {
                    return;
                }
                this.parameters.getNode((int)rowIndex).value = s;
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        } else {
            LOG.warning("Edited value is not a String!");
        }
    }
}

