/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

public class SavedSettingsFile
implements Iterable<Pair<String, ArrayList<String>>> {
    public static final String COMMENT_PREFIX = "#";
    private File file;
    private ArrayList<Pair<String, ArrayList<String>>> store;

    public SavedSettingsFile(String filename) {
        this.file = new File(filename);
        this.store = new ArrayList();
    }

    public void save() throws FileNotFoundException {
        PrintStream p = new PrintStream(this.file);
        p.println("#Saved ELKI settings. First line is title, remaining lines are parameters.");
        for (Pair<String, ArrayList<String>> settings : this.store) {
            p.println((String)settings.first);
            for (String str : (ArrayList)settings.second) {
                p.println(str);
            }
            p.println();
        }
        p.close();
    }

    public void load() throws FileNotFoundException, IOException {
        BufferedReader is = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
        ArrayList<String> buf = new ArrayList<String>();
        while (is.ready()) {
            String line = is.readLine();
            if (line.startsWith(COMMENT_PREFIX)) continue;
            if (line.length() == 0 && !buf.isEmpty()) {
                String title = (String)buf.remove(0);
                this.store.add(new Pair(title, buf));
                buf = new ArrayList();
                continue;
            }
            buf.add(line);
        }
        if (!buf.isEmpty()) {
            String title = (String)buf.remove(0);
            this.store.add(new Pair(title, buf));
            buf = new ArrayList();
        }
        is.close();
    }

    @Override
    public Iterator<Pair<String, ArrayList<String>>> iterator() {
        return this.store.iterator();
    }

    public void remove(String key) {
        Iterator<Pair<String, ArrayList<String>>> it = this.store.iterator();
        while (it.hasNext()) {
            String thisKey = (String)it.next().first;
            if (!key.equals(thisKey)) continue;
            it.remove();
            break;
        }
    }

    public ArrayList<String> get(String key) {
        for (Pair<String, ArrayList<String>> pair : this.store) {
            if (!key.equals(pair.first)) continue;
            return (ArrayList)pair.second;
        }
        return null;
    }

    public void clear() {
        this.store.clear();
    }

    public void put(String key, ArrayList<String> value) {
        for (Pair<String, ArrayList<String>> pair : this.store) {
            if (!key.equals(pair.first)) continue;
            pair.second = value;
            return;
        }
        this.store.add(new Pair<String, ArrayList<String>>(key, value));
    }

    public int size() {
        return this.store.size();
    }

    public Pair<String, ArrayList<String>> getElementAt(int index) {
        return this.store.get(index);
    }
}

