/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class TreePopup
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    public static final String ACTION_SELECTED = "selected";
    public static final String ACTION_CANCELED = "canceled";
    protected JTree tree;
    protected JScrollPane scroller;
    private TreeModel model;
    private Handler handler = new Handler();
    private static Border TREE_BORDER = new LineBorder(Color.BLACK, 1);

    public TreePopup() {
        this(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.tree.setRootVisible(false);
    }

    public TreePopup(TreeModel model) {
        this.setName("TreePopup.popup");
        this.model = model;
        this.tree = this.createTree();
        this.scroller = this.createScroller();
        this.configurePopup();
    }

    protected JTree createTree() {
        JTree tree = new JTree(this.model);
        tree.setName("TreePopup.tree");
        tree.setFont(this.getFont());
        tree.setForeground(this.getForeground());
        tree.setBackground(this.getBackground());
        tree.setBorder(null);
        tree.setFocusable(true);
        tree.addMouseListener(this.handler);
        tree.addKeyListener(this.handler);
        tree.setCellRenderer(new Renderer());
        return tree;
    }

    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(TREE_BORDER);
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
    }

    protected JScrollPane createScroller() {
        JScrollPane sp = new JScrollPane(this.tree, 20, 31);
        sp.setHorizontalScrollBar(null);
        sp.setName("TreePopup.scrollPane");
        sp.setFocusable(false);
        sp.getVerticalScrollBar().setFocusable(false);
        sp.setBorder(null);
        return sp;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void show(Component parent) {
        Dimension parentSize = parent.getSize();
        Insets insets = this.getInsets();
        parentSize.setSize(parentSize.width - (insets.right + insets.left), 10 * parentSize.height);
        Dimension scrollSize = this.computePopupBounds(parent, 0, this.getBounds().height, parentSize.width, parentSize.height).getSize();
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
        super.show(parent, 0, parent.getHeight());
        this.tree.requestFocusInWindow();
    }

    protected Rectangle computePopupBounds(Component parent, int px, int py, int pw, int ph) {
        Rectangle screenBounds;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = parent.getGraphicsConfiguration();
        Point p = new Point();
        SwingUtilities.convertPointFromScreen(p, parent);
        if (gc != null) {
            Insets screenInsets = toolkit.getScreenInsets(gc);
            screenBounds = gc.getBounds();
            screenBounds.width -= screenInsets.left + screenInsets.right;
            screenBounds.height -= screenInsets.top + screenInsets.bottom;
            screenBounds.x += p.x + screenInsets.left;
            screenBounds.y += p.y + screenInsets.top;
        } else {
            screenBounds = new Rectangle(p, toolkit.getScreenSize());
        }
        Rectangle rect = new Rectangle(px, py, pw, ph);
        if (py + ph > screenBounds.y + screenBounds.height && ph < screenBounds.height) {
            rect.y = -rect.height;
        }
        return rect;
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    protected class Handler
    implements MouseListener,
    KeyListener,
    FocusListener {
        protected Handler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\n') {
                e.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                TreePopup.this.fireActionPerformed(new ActionEvent(TreePopup.this, 1001, TreePopup.ACTION_SELECTED, e.getWhen(), e.getModifiers()));
                e.consume();
                return;
            }
            if (e.getKeyCode() == 27) {
                TreePopup.this.fireActionPerformed(new ActionEvent(TreePopup.this, 1001, TreePopup.ACTION_CANCELED, e.getWhen(), e.getModifiers()));
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                e.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                TreePopup.this.fireActionPerformed(new ActionEvent(TreePopup.this, 1001, TreePopup.ACTION_SELECTED, e.getWhen(), e.getModifiers()));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            TreePopup.this.fireActionPerformed(new ActionEvent(TreePopup.this, 1001, TreePopup.ACTION_CANCELED));
        }
    }

    public class Renderer
    extends JPanel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 1L;
        JLabel label;
        private Color selbg = UIManager.getColor("Tree.selectionBackground");
        private Color defbg = UIManager.getColor("Tree.textBackground");
        private Color selfg = UIManager.getColor("Tree.selectionForeground");
        private Color deffg = UIManager.getColor("Tree.textForeground");
        private Icon leafIcon;
        private Icon folderIcon;

        protected Renderer() {
            this.setLayout(new BorderLayout());
            this.label = new JLabel("This should never be rendered.");
            this.add(this.label);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.label.setText((String)((DefaultMutableTreeNode)value).getUserObject());
            this.setForeground(selected ? this.selfg : this.deffg);
            this.setBackground(selected ? this.selbg : this.defbg);
            this.label.setIcon(leaf ? this.leafIcon : this.folderIcon);
            this.setPreferredSize(new Dimension(1000, this.label.getPreferredSize().height));
            return this;
        }

        public void setLeafIcon(Icon leafIcon) {
            this.leafIcon = leafIcon;
        }

        public void setFolderIcon(Icon folderIcon) {
            this.folderIcon = folderIcon;
        }
    }
}

