/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.AbstractIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;

public abstract class AbstractRefiningIndex<O>
extends AbstractIndex<O> {
    private Counter refinements;

    public AbstractRefiningIndex(Relation<O> relation) {
        super(relation);
        Logging log = this.getLogger();
        this.refinements = log.isStatistics() ? log.newCounter(this.getClass().getName() + ".refinements") : null;
    }

    public abstract Logging getLogger();

    protected void countRefinements(int i) {
        if (this.refinements != null) {
            this.refinements.increment(i);
        }
    }

    @Override
    public void logStatistics() {
        if (this.refinements != null) {
            this.getLogger().statistics(this.refinements);
        }
    }

    protected O refine(DBID id) {
        this.countRefinements(1);
        return this.relation.get(id);
    }

    public abstract class AbstractKNNQuery
    extends AbstractDistanceKNNQuery<O> {
        public AbstractKNNQuery(DistanceQuery<O> distanceQuery) {
            super(distanceQuery);
        }

        protected double refine(DBIDRef id, O q) {
            AbstractRefiningIndex.this.countRefinements(1);
            return this.distanceQuery.distance(q, id);
        }

        protected void incRefinements(int c) {
            AbstractRefiningIndex.this.countRefinements(c);
        }
    }

    public abstract class AbstractRangeQuery
    extends AbstractDistanceRangeQuery<O> {
        public AbstractRangeQuery(DistanceQuery<O> distanceQuery) {
            super(distanceQuery);
        }

        protected double refine(DBIDRef id, O q) {
            AbstractRefiningIndex.this.countRefinements(1);
            return this.distanceQuery.distance(q, id);
        }

        protected void incRefinements(int c) {
            AbstractRefiningIndex.this.countRefinements(c);
        }
    }
}

