/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index;

import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.persistent.MemoryPageFileFactory;
import de.lmu.ifi.dbs.elki.persistent.Page;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.persistent.PageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.io.Externalizable;

public abstract class PagedIndexFactory<O>
implements IndexFactory<O> {
    private PageFileFactory<?> pageFileFactory;

    public PagedIndexFactory(PageFileFactory<?> pageFileFactory) {
        this.pageFileFactory = pageFileFactory;
    }

    protected <N extends Page & Externalizable> PageFile<N> makePageFile(Class<N> cls) {
        PageFileFactory<?> castFactory = this.pageFileFactory;
        return castFactory.newPageFile(cls);
    }

    public static abstract class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID PAGEFILE_ID = new OptionID("index.pagefile", "The pagefile factory for storing the index.");
        protected PageFileFactory<?> pageFileFactory;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter pffP = new ObjectParameter(PAGEFILE_ID, (Class<?>)PageFileFactory.class, MemoryPageFileFactory.class);
            if (config.grab(pffP)) {
                this.pageFileFactory = (PageFileFactory)pffP.instantiateClass(config);
            }
        }

        @Override
        protected abstract PagedIndexFactory<O> makeInstance();
    }
}

