/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.distancematrix;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.DistanceIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.List;

public class PrecomputedDistanceMatrix<O>
implements DistanceIndex<O>,
RangeIndex<O>,
KNNIndex<O> {
    private static final Logging LOG = Logging.getLogger(PrecomputedDistanceMatrix.class);
    protected final Relation<O> relation;
    protected final DistanceFunction<? super O> distanceFunction;
    protected DistanceQuery<O> distanceQuery;
    private double[] matrix = null;
    private DBIDRange ids;
    private int size;

    public PrecomputedDistanceMatrix(Relation<O> relation, DBIDRange range, DistanceFunction<? super O> distanceFunction) {
        this.relation = relation;
        this.ids = range;
        this.distanceFunction = distanceFunction;
        if (!distanceFunction.isSymmetric()) {
            throw new AbortException("Distance matrixes currently only support symmetric distance functions (Patches welcome).");
        }
    }

    @Override
    public void initialize() {
        this.size = this.ids.size();
        if (this.size > 65536) {
            throw new AbortException("Distance matrixes currently have a limit of 65536 objects (~16 GB). After this, the array size exceeds the Java integer range, and a different data structure needs to be used.");
        }
        this.distanceQuery = this.distanceFunction.instantiate(this.relation);
        int msize = PrecomputedDistanceMatrix.triangleSize(this.size);
        this.matrix = new double[msize];
        DBIDArrayIter ix = this.ids.iter();
        DBIDArrayIter iy = this.ids.iter();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Precomputing distance matrix", msize, LOG) : null;
        int pos = 0;
        ix.seek(0);
        while (ix.valid()) {
            iy.seek(0);
            while (iy.getOffset() < ix.getOffset()) {
                this.matrix[pos] = this.distanceQuery.distance((DBIDRef)ix, (DBIDRef)iy);
                ++pos;
                iy.advance();
            }
            if (prog != null) {
                prog.setProcessed(prog.getProcessed() + ix.getOffset(), LOG);
            }
            ix.advance();
        }
        LOG.ensureCompleted(prog);
    }

    protected static int triangleSize(int x) {
        return x * (x - 1) >>> 1;
    }

    private int getOffset(int x, int y) {
        return y < x ? PrecomputedDistanceMatrix.triangleSize(x) + y : PrecomputedDistanceMatrix.triangleSize(y) + x;
    }

    @Override
    public void logStatistics() {
        if (this.matrix != null) {
            LOG.statistics(new LongStatistic(this.getClass().getName() + ".matrix-size", this.matrix.length));
        }
    }

    @Override
    public String getLongName() {
        return "Precomputed Distance Matrix";
    }

    @Override
    public String getShortName() {
        return "distance-matrix";
    }

    @Override
    public DistanceQuery<O> getDistanceQuery(DistanceFunction<? super O> distanceFunction, Object ... hints) {
        if (this.distanceFunction.equals(distanceFunction)) {
            return new PrecomputedDistanceQuery();
        }
        return null;
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (this.distanceFunction.equals(distanceQuery.getDistanceFunction())) {
            return new PrecomputedKNNQuery();
        }
        return null;
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (this.distanceFunction.equals(distanceQuery.getDistanceFunction())) {
            return new PrecomputedRangeQuery();
        }
        return null;
    }

    public static class Factory<O>
    implements IndexFactory<O> {
        protected final DistanceFunction<? super O> distanceFunction;

        public Factory(DistanceFunction<? super O> distanceFunction) {
            this.distanceFunction = distanceFunction;
        }

        public PrecomputedDistanceMatrix<O> instantiate(Relation<O> relation) {
            DBIDs rids = relation.getDBIDs();
            if (!(rids instanceof DBIDRange)) {
                throw new AbortException("Distance matrixes are currently only supported for DBID ranges (as used by static databases; not on modifiable databases) for performance reasons (Patches welcome).");
            }
            return new PrecomputedDistanceMatrix<O>(relation, (DBIDRange)rids, this.distanceFunction);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.distanceFunction.getInputTypeRestriction();
        }

        public static class Parameterizer<O>
        extends AbstractParameterizer {
            public static final OptionID DISTANCE_ID = new OptionID("matrix.distance", "Distance function for the precomputed distance matrix.");
            protected DistanceFunction<? super O> distanceFunction;

            @Override
            protected void makeOptions(Parameterization config) {
                super.makeOptions(config);
                ObjectParameter distanceP = new ObjectParameter(DISTANCE_ID, DistanceFunction.class);
                if (config.grab(distanceP)) {
                    this.distanceFunction = (DistanceFunction)distanceP.instantiateClass(config);
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory<O>(this.distanceFunction);
            }
        }
    }

    private class PrecomputedKNNQuery
    implements KNNQuery<O> {
        private PrecomputedKNNQuery() {
        }

        @Override
        public KNNList getKNNForDBID(DBIDRef id, int k) {
            double dist;
            int y;
            KNNHeap heap = DBIDUtil.newHeap(k);
            heap.insert(0.0, id);
            DBIDArrayIter it = PrecomputedDistanceMatrix.this.ids.iter();
            double max = Double.POSITIVE_INFINITY;
            int x = PrecomputedDistanceMatrix.this.ids.getOffset(id);
            int pos = PrecomputedDistanceMatrix.triangleSize(x);
            for (y = 0; y < x; ++y) {
                dist = PrecomputedDistanceMatrix.this.matrix[pos];
                if (dist <= max) {
                    max = heap.insert(dist, it.seek(y));
                }
                ++pos;
            }
            assert (pos == PrecomputedDistanceMatrix.triangleSize(x + 1));
            pos = PrecomputedDistanceMatrix.triangleSize(x + 1) + x;
            for (y = x + 1; y < PrecomputedDistanceMatrix.this.size; ++y) {
                dist = PrecomputedDistanceMatrix.this.matrix[pos];
                if (dist <= max) {
                    max = heap.insert(dist, it.seek(y));
                }
                pos += y;
            }
            return heap.toKNNList();
        }

        @Override
        public List<? extends KNNList> getKNNForBulkDBIDs(ArrayDBIDs ids, int k) {
            ArrayList<KNNList> ret = new ArrayList<KNNList>(ids.size());
            DBIDArrayIter iter = ids.iter();
            while (iter.valid()) {
                ret.add(this.getKNNForDBID(iter, k));
                iter.advance();
            }
            return ret;
        }

        @Override
        public KNNList getKNNForObject(O obj, int k) {
            throw new AbortException("Preprocessor KNN query only supports ID queries.");
        }
    }

    private class PrecomputedRangeQuery
    implements RangeQuery<O> {
        private PrecomputedRangeQuery() {
        }

        @Override
        public DoubleDBIDList getRangeForDBID(DBIDRef id, double range) {
            ModifiableDoubleDBIDList ret = DBIDUtil.newDistanceDBIDList();
            this.getRangeForDBID(id, range, ret);
            ret.sort();
            return ret;
        }

        @Override
        public void getRangeForDBID(DBIDRef id, double range, ModifiableDoubleDBIDList result) {
            double dist;
            int y;
            result.add(0.0, id);
            DBIDArrayIter it = PrecomputedDistanceMatrix.this.ids.iter();
            int x = PrecomputedDistanceMatrix.this.ids.getOffset(id);
            int pos = PrecomputedDistanceMatrix.triangleSize(x);
            for (y = 0; y < x; ++y) {
                dist = PrecomputedDistanceMatrix.this.matrix[pos];
                if (dist <= range) {
                    result.add(dist, it.seek(y));
                }
                ++pos;
            }
            assert (pos == PrecomputedDistanceMatrix.triangleSize(x + 1));
            pos = PrecomputedDistanceMatrix.triangleSize(x + 1) + x;
            for (y = x + 1; y < PrecomputedDistanceMatrix.this.size; ++y) {
                dist = PrecomputedDistanceMatrix.this.matrix[pos];
                if (dist <= range) {
                    result.add(dist, it.seek(y));
                }
                pos += y;
            }
        }

        @Override
        public DoubleDBIDList getRangeForObject(O obj, double range) {
            throw new AbortException("Preprocessor KNN query only supports ID queries.");
        }

        @Override
        public void getRangeForObject(O obj, double range, ModifiableDoubleDBIDList result) {
            throw new AbortException("Preprocessor KNN query only supports ID queries.");
        }
    }

    private class PrecomputedDistanceQuery
    implements DistanceQuery<O> {
        private PrecomputedDistanceQuery() {
        }

        @Override
        public double distance(DBIDRef id1, DBIDRef id2) {
            int y;
            int x = PrecomputedDistanceMatrix.this.ids.getOffset(id1);
            return x != (y = PrecomputedDistanceMatrix.this.ids.getOffset(id2)) ? PrecomputedDistanceMatrix.this.matrix[PrecomputedDistanceMatrix.this.getOffset(x, y)] : 0.0;
        }

        @Override
        public double distance(O o1, DBIDRef id2) {
            return PrecomputedDistanceMatrix.this.distanceQuery.distance((DBIDRef)o1, id2);
        }

        @Override
        public double distance(DBIDRef id1, O o2) {
            return PrecomputedDistanceMatrix.this.distanceQuery.distance(id1, (DBIDRef)o2);
        }

        @Override
        public double distance(O o1, O o2) {
            return PrecomputedDistanceMatrix.this.distanceQuery.distance(o1, o2);
        }

        @Override
        public DistanceFunction<? super O> getDistanceFunction() {
            return PrecomputedDistanceMatrix.this.distanceQuery.getDistanceFunction();
        }

        @Override
        public Relation<? extends O> getRelation() {
            return PrecomputedDistanceMatrix.this.relation;
        }
    }
}

