/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.distancematrix;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.index.AbstractIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.SimilarityIndex;
import de.lmu.ifi.dbs.elki.index.SimilarityRangeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public class PrecomputedSimilarityMatrix<O>
extends AbstractIndex<O>
implements SimilarityIndex<O>,
SimilarityRangeIndex<O> {
    private static final Logging LOG = Logging.getLogger(PrecomputedSimilarityMatrix.class);
    protected final SimilarityFunction<? super O> similarityFunction;
    protected SimilarityQuery<O> similarityQuery;
    private double[] matrix = null;
    private DBIDRange ids;
    private int size;

    public PrecomputedSimilarityMatrix(Relation<O> relation, SimilarityFunction<? super O> similarityFunction) {
        super(relation);
        this.similarityFunction = similarityFunction;
        if (!similarityFunction.isSymmetric()) {
            throw new AbortException("Similarity matrixes currently only support symmetric similarity functions (Patches welcome).");
        }
    }

    @Override
    public void initialize() {
        DBIDs rids = this.relation.getDBIDs();
        if (!(rids instanceof DBIDRange)) {
            throw new AbortException("Similarity matrixes are currently only supported for DBID ranges (as used by static databases) for performance reasons (Patches welcome).");
        }
        this.ids = (DBIDRange)rids;
        this.size = this.ids.size();
        if (this.size > 65536) {
            throw new AbortException("Similarity matrixes currently have a limit of 65536 objects (~16 GB). After this, the array size exceeds the Java integer range, and a different data structure needs to be used.");
        }
        this.similarityQuery = this.similarityFunction.instantiate(this.relation);
        int msize = PrecomputedSimilarityMatrix.triangleSize(this.size);
        this.matrix = new double[msize];
        DBIDArrayIter ix = this.ids.iter();
        DBIDArrayIter iy = this.ids.iter();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Precomputing similarity matrix", msize, LOG) : null;
        int pos = 0;
        ix.seek(0);
        while (ix.valid()) {
            iy.seek(0);
            while (iy.getOffset() < ix.getOffset()) {
                this.matrix[pos] = this.similarityQuery.similarity((DBIDRef)ix, (DBIDRef)iy);
                ++pos;
                iy.advance();
            }
            if (prog != null) {
                prog.setProcessed(prog.getProcessed() + ix.getOffset(), LOG);
            }
            ix.advance();
        }
        LOG.ensureCompleted(prog);
    }

    protected static int triangleSize(int x) {
        return x * (x - 1) >>> 1;
    }

    private int getOffset(int x, int y) {
        return y < x ? PrecomputedSimilarityMatrix.triangleSize(x) + y : PrecomputedSimilarityMatrix.triangleSize(y) + x;
    }

    @Override
    public void logStatistics() {
        if (this.matrix != null) {
            LOG.statistics(new LongStatistic(this.getClass().getName() + ".matrix-size", this.matrix.length));
        }
    }

    @Override
    public String getLongName() {
        return "Precomputed Similarity Matrix";
    }

    @Override
    public String getShortName() {
        return "similarity-matrix";
    }

    @Override
    public SimilarityQuery<O> getSimilarityQuery(SimilarityFunction<? super O> similarityFunction, Object ... hints) {
        if (this.similarityFunction.equals(similarityFunction)) {
            return new PrecomputedSimilarityQuery();
        }
        return null;
    }

    @Override
    public RangeQuery<O> getSimilarityRangeQuery(SimilarityQuery<O> simQuery, Object ... hints) {
        if (this.similarityFunction.equals(simQuery.getSimilarityFunction())) {
            return new PrecomputedSimilarityRangeQuery();
        }
        return null;
    }

    public static class Factory<O>
    implements IndexFactory<O> {
        protected final SimilarityFunction<? super O> similarityFunction;

        public Factory(SimilarityFunction<? super O> similarityFunction) {
            this.similarityFunction = similarityFunction;
        }

        public PrecomputedSimilarityMatrix<O> instantiate(Relation<O> relation) {
            return new PrecomputedSimilarityMatrix<O>(relation, this.similarityFunction);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.similarityFunction.getInputTypeRestriction();
        }

        public static class Parameterizer<O>
        extends AbstractParameterizer {
            public static final OptionID DISTANCE_ID = new OptionID("matrix.similarity", "Similarity function for the precomputed similarity matrix.");
            protected SimilarityFunction<? super O> similarityFunction;

            @Override
            protected void makeOptions(Parameterization config) {
                super.makeOptions(config);
                ObjectParameter similarityP = new ObjectParameter(DISTANCE_ID, SimilarityFunction.class);
                if (config.grab(similarityP)) {
                    this.similarityFunction = (SimilarityFunction)similarityP.instantiateClass(config);
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory<O>(this.similarityFunction);
            }
        }
    }

    private class PrecomputedSimilarityRangeQuery
    implements RangeQuery<O> {
        private PrecomputedSimilarityRangeQuery() {
        }

        @Override
        public DoubleDBIDList getRangeForDBID(DBIDRef id, double range) {
            ModifiableDoubleDBIDList ret = DBIDUtil.newDistanceDBIDList();
            this.getRangeForDBID(id, range, ret);
            ret.sort();
            return ret;
        }

        @Override
        public void getRangeForDBID(DBIDRef id, double range, ModifiableDoubleDBIDList result) {
            double sim;
            int y;
            result.add(0.0, id);
            DBIDArrayIter it = PrecomputedSimilarityMatrix.this.ids.iter();
            int x = PrecomputedSimilarityMatrix.this.ids.getOffset(id);
            int pos = PrecomputedSimilarityMatrix.triangleSize(x);
            for (y = 0; y < x; ++y) {
                sim = PrecomputedSimilarityMatrix.this.matrix[pos];
                if (sim >= range) {
                    result.add(sim, it.seek(y));
                }
                ++pos;
            }
            assert (pos == PrecomputedSimilarityMatrix.triangleSize(x + 1));
            pos = PrecomputedSimilarityMatrix.triangleSize(x + 1) + x;
            for (y = x + 1; y < PrecomputedSimilarityMatrix.this.size; ++y) {
                sim = PrecomputedSimilarityMatrix.this.matrix[pos];
                if (sim >= range) {
                    result.add(sim, it.seek(y));
                }
                pos += y;
            }
        }

        @Override
        public DoubleDBIDList getRangeForObject(O obj, double range) {
            throw new AbortException("Preprocessor KNN query only supports ID queries.");
        }

        @Override
        public void getRangeForObject(O obj, double range, ModifiableDoubleDBIDList result) {
            throw new AbortException("Preprocessor KNN query only supports ID queries.");
        }
    }

    private class PrecomputedSimilarityQuery
    implements SimilarityQuery<O> {
        private PrecomputedSimilarityQuery() {
        }

        @Override
        public double similarity(DBIDRef id1, DBIDRef id2) {
            int y;
            int x = PrecomputedSimilarityMatrix.this.ids.getOffset(id1);
            return x != (y = PrecomputedSimilarityMatrix.this.ids.getOffset(id2)) ? PrecomputedSimilarityMatrix.this.matrix[PrecomputedSimilarityMatrix.this.getOffset(x, y)] : 0.0;
        }

        @Override
        public double similarity(O o1, DBIDRef id2) {
            return PrecomputedSimilarityMatrix.this.similarityQuery.similarity((DBIDRef)o1, id2);
        }

        @Override
        public double similarity(DBIDRef id1, O o2) {
            return PrecomputedSimilarityMatrix.this.similarityQuery.similarity(id1, (DBIDRef)o2);
        }

        @Override
        public double similarity(O o1, O o2) {
            return PrecomputedSimilarityMatrix.this.similarityQuery.similarity(o1, o2);
        }

        @Override
        public SimilarityFunction<? super O> getSimilarityFunction() {
            return PrecomputedSimilarityMatrix.this.similarityQuery.getSimilarityFunction();
        }

        @Override
        public Relation<? extends O> getRelation() {
            return PrecomputedSimilarityMatrix.this.relation;
        }
    }
}

