/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.idistance;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractRefiningIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.MeanVarianceMinMax;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleIntPair;
import java.util.Arrays;

@References(value={@Reference(authors="C. Yu, B. C. Ooi, K. L. Tan, H. V. Jagadish", title="Indexing the distance: An efficient method to knn processing", booktitle="Proc. 27th Int. Conf. on Very Large Data Bases", url="http://www.vldb.org/conf/2001/P421.pdf", bibkey="DBLP:conf/vldb/OoiYTJ01"), @Reference(authors="H. V. Jagadish, B. C. Ooi, K. L. Tan, C. Yu, R. Zhang", title="iDistance: An adaptive B+-tree based indexing method for nearest neighbor search", booktitle="ACM Transactions on Database Systems (TODS), 30(2)", url="https://doi.org/10.1145/1071610.1071612", bibkey="DBLP:journals/tods/JagadishOTYZ05")})
public class InMemoryIDistanceIndex<O>
extends AbstractRefiningIndex<O>
implements RangeIndex<O>,
KNNIndex<O> {
    private static final Logging LOG = Logging.getLogger(InMemoryIDistanceIndex.class);
    private DistanceQuery<O> distanceQuery;
    private KMedoidsInitialization<O> initialization;
    private int numref;
    private ArrayDBIDs referencepoints;
    private ModifiableDoubleDBIDList[] index;

    public InMemoryIDistanceIndex(Relation<O> relation, DistanceQuery<O> distance, KMedoidsInitialization<O> initialization, int numref) {
        super(relation);
        this.distanceQuery = distance;
        this.initialization = initialization;
        this.numref = numref;
        if (!distance.getDistanceFunction().isMetric()) {
            LOG.warning("iDistance assumes metric distance functions.\n" + distance.getDistanceFunction().getClass() + " does not report itself as metric.\niDistance will run, but may yield approximate results.");
        }
    }

    @Override
    public void initialize() {
        this.referencepoints = DBIDUtil.ensureArray(this.initialization.chooseInitialMedoids(this.numref, this.relation.getDBIDs(), this.distanceQuery));
        int k = this.referencepoints.size();
        this.index = new ModifiableDoubleDBIDList[k];
        for (int i = 0; i < k; ++i) {
            this.index[i] = DBIDUtil.newDistanceDBIDList(this.relation.size() / (2 * k));
        }
        DBIDArrayIter riter = this.referencepoints.iter();
        DBIDIter oiter = this.relation.iterDBIDs();
        while (oiter.valid()) {
            double bestd = Double.POSITIVE_INFINITY;
            int besti = -1;
            riter.seek(0);
            while (riter.valid()) {
                double dist = this.distanceQuery.distance((DBIDRef)oiter, (DBIDRef)riter);
                if (dist < bestd) {
                    bestd = dist;
                    besti = riter.getOffset();
                }
                riter.advance();
            }
            assert (besti >= 0 && besti < k);
            this.index[besti].add(bestd, oiter);
            oiter.advance();
        }
        for (int i = 0; i < k; ++i) {
            this.index[i].sort();
        }
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            if (LOG.isDebugging()) {
                LOG.debug("Distance function not supported by index - or 'equals' not implemented right!");
            }
            return null;
        }
        return new IDistanceKNNQuery(distanceQuery);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            if (LOG.isDebugging()) {
                LOG.debug("Distance function not supported by index - or 'equals' not implemented right!");
            }
            return null;
        }
        return new IDistanceRangeQuery(distanceQuery);
    }

    private DistanceFunction<? super O> getDistanceFunction() {
        return this.distanceQuery.getDistanceFunction();
    }

    @Override
    public String getLongName() {
        return "iDistance index";
    }

    @Override
    public String getShortName() {
        return "idistance-index";
    }

    @Override
    public Logging getLogger() {
        return LOG;
    }

    @Override
    public void logStatistics() {
        super.logStatistics();
        MeanVarianceMinMax mm = new MeanVarianceMinMax();
        for (int i = 0; i < this.index.length; ++i) {
            mm.put(this.index[i].size());
        }
        LOG.statistics(new LongStatistic(InMemoryIDistanceIndex.class.getName() + ".size.min", (int)mm.getMin()));
        LOG.statistics(new DoubleStatistic(InMemoryIDistanceIndex.class.getName() + ".size.mean", mm.getMean()));
        LOG.statistics(new LongStatistic(InMemoryIDistanceIndex.class.getName() + ".size.max", (int)mm.getMax()));
    }

    protected static <O> DoubleIntPair[] rankReferencePoints(DistanceQuery<O> distanceQuery, O obj, ArrayDBIDs referencepoints) {
        Object[] priority = new DoubleIntPair[referencepoints.size()];
        DBIDArrayIter iter = referencepoints.iter();
        while (iter.valid()) {
            int i = iter.getOffset();
            double dist = distanceQuery.distance((DBIDArrayIter)obj, iter);
            priority[i] = new DoubleIntPair(dist, i);
            iter.advance();
        }
        Arrays.sort(priority);
        return priority;
    }

    protected static void binarySearch(ModifiableDoubleDBIDList index, DoubleDBIDListIter iter, double val) {
        int left = 0;
        int right = index.size();
        while (left < right) {
            int mid = left + right >>> 1;
            double curd = iter.seek(mid).doubleValue();
            if (val < curd) {
                right = mid;
                continue;
            }
            if (val > curd) {
                left = mid + 1;
                continue;
            }
            left = mid;
            break;
        }
        if (left >= index.size()) {
            --left;
        }
        iter.seek(left);
    }

    public static class Factory<V>
    implements IndexFactory<V> {
        DistanceFunction<? super V> distance;
        KMedoidsInitialization<V> initialization;
        int k;

        public Factory(DistanceFunction<? super V> distance, KMedoidsInitialization<V> initialization, int k) {
            this.distance = distance;
            this.initialization = initialization;
            this.k = k;
        }

        @Override
        public InMemoryIDistanceIndex<V> instantiate(Relation<V> relation) {
            return new InMemoryIDistanceIndex<V>(relation, this.distance.instantiate(relation), this.initialization, this.k);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.distance.getInputTypeRestriction();
        }

        public static class Parameterizer<V>
        extends AbstractParameterizer {
            public static final OptionID DISTANCE_ID = new OptionID("idistance.distance", "Distance function to build the index for.");
            public static final OptionID REFERENCE_ID = new OptionID("idistance.reference", "Method to choose the reference points.");
            public static final OptionID K_ID = new OptionID("idistance.k", "Number of reference points to use.");
            DistanceFunction<? super V> distance;
            KMedoidsInitialization<V> initialization;
            int k;

            @Override
            protected void makeOptions(Parameterization config) {
                IntParameter kP;
                ObjectParameter initializationP;
                super.makeOptions(config);
                ObjectParameter distanceP = new ObjectParameter(DISTANCE_ID, DistanceFunction.class);
                if (config.grab(distanceP)) {
                    this.distance = (DistanceFunction)distanceP.instantiateClass(config);
                }
                if (config.grab(initializationP = new ObjectParameter(REFERENCE_ID, KMedoidsInitialization.class))) {
                    this.initialization = (KMedoidsInitialization)initializationP.instantiateClass(config);
                }
                if (config.grab(kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                    this.k = kP.intValue();
                }
            }

            @Override
            protected Factory<V> makeInstance() {
                return new Factory<V>(this.distance, this.initialization, this.k);
            }
        }
    }

    protected class IDistanceRangeQuery
    extends AbstractRefiningIndex.AbstractRangeQuery {
        public IDistanceRangeQuery(DistanceQuery<O> distanceQuery) {
            super(InMemoryIDistanceIndex.this, distanceQuery);
        }

        @Override
        public void getRangeForObject(O obj, double range, ModifiableDoubleDBIDList result) {
            DoubleIntPair[] priority;
            for (DoubleIntPair pair : priority = InMemoryIDistanceIndex.rankReferencePoints(this.distanceQuery, obj, InMemoryIDistanceIndex.this.referencepoints)) {
                double lbbwd;
                ModifiableDoubleDBIDList nindex = InMemoryIDistanceIndex.this.index[pair.second];
                double refd = pair.first;
                DoubleDBIDListMIter ifwd = nindex.iter();
                DoubleDBIDListMIter ibwd = nindex.iter();
                InMemoryIDistanceIndex.binarySearch(nindex, ibwd, refd);
                ifwd.seek(ibwd.getOffset() + 1);
                double lbfwd = ifwd.valid() ? Math.abs(ifwd.doubleValue() - refd) : Double.NaN;
                double d = lbbwd = ibwd.valid() ? Math.abs(ibwd.doubleValue() - refd) : Double.NaN;
                while (lbfwd <= range || lbbwd <= range) {
                    double dist;
                    if (lbfwd <= range && !(lbfwd > lbbwd)) {
                        dist = this.refine(ifwd, obj);
                        if (dist <= range) {
                            result.add(dist, ifwd);
                        }
                        ifwd.advance();
                        double d2 = lbfwd = ifwd.valid() ? Math.abs(ifwd.doubleValue() - refd) : Double.NaN;
                    }
                    if (!(lbbwd <= range) || lbbwd > lbfwd) continue;
                    dist = this.refine(ibwd, obj);
                    if (dist <= range) {
                        result.add(dist, ibwd);
                    }
                    ibwd.retract();
                    lbbwd = ibwd.valid() ? Math.abs(ibwd.doubleValue() - refd) : Double.NaN;
                }
            }
        }
    }

    protected class IDistanceKNNQuery
    extends AbstractRefiningIndex.AbstractKNNQuery {
        public IDistanceKNNQuery(DistanceQuery<O> distanceQuery) {
            super(InMemoryIDistanceIndex.this, distanceQuery);
        }

        @Override
        public KNNList getKNNForObject(O obj, int k) {
            DoubleIntPair[] priority = InMemoryIDistanceIndex.rankReferencePoints(this.distanceQuery, obj, InMemoryIDistanceIndex.this.referencepoints);
            KNNHeap heap = DBIDUtil.newHeap(k);
            for (DoubleIntPair pair : priority) {
                ModifiableDoubleDBIDList nindex = InMemoryIDistanceIndex.this.index[pair.second];
                double refd = pair.first;
                DoubleDBIDListMIter ifwd = nindex.iter();
                DoubleDBIDListMIter ibwd = nindex.iter();
                InMemoryIDistanceIndex.binarySearch(nindex, ibwd, refd);
                ifwd.seek(ibwd.getOffset() + 1);
                double lbfwd = ifwd.valid() ? Math.abs(ifwd.doubleValue() - refd) : Double.NaN;
                double lbbwd = ibwd.valid() ? Math.abs(ibwd.doubleValue() - refd) : Double.NaN;
                double kdist = heap.getKNNDistance();
                while (lbfwd <= kdist || lbbwd <= kdist) {
                    double dist;
                    if (lbfwd <= kdist && !(lbfwd > lbbwd)) {
                        dist = this.refine(ifwd, obj);
                        if (dist <= kdist) {
                            heap.insert(dist, ifwd);
                            kdist = heap.getKNNDistance();
                        }
                        ifwd.advance();
                        double d = lbfwd = ifwd.valid() ? Math.abs(ifwd.doubleValue() - refd) : Double.NaN;
                    }
                    if (!(lbbwd <= kdist) || lbbwd > lbfwd) continue;
                    dist = this.refine(ibwd, obj);
                    if (dist <= kdist) {
                        heap.insert(dist, ibwd);
                        kdist = heap.getKNNDistance();
                    }
                    ibwd.retract();
                    lbbwd = ibwd.valid() ? Math.abs(ibwd.doubleValue() - refd) : Double.NaN;
                }
            }
            return heap.toKNNList();
        }
    }
}

