/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.invertedlist;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.ArcCosineDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.CosineDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;
import net.jafama.FastMath;

public class InMemoryInvertedIndex<V extends NumberVector>
extends AbstractIndex<V>
implements KNNIndex<V>,
RangeIndex<V> {
    private static final Logging LOG = Logging.getLogger(InMemoryInvertedIndex.class);
    ArrayList<ModifiableDoubleDBIDList> index;
    WritableDoubleDataStore length;

    public InMemoryInvertedIndex(Relation<V> relation) {
        super(relation);
    }

    @Override
    public void initialize() {
        if (this.index != null) {
            LOG.warning("Index was already initialized!");
        }
        this.index = new ArrayList();
        this.length = DataStoreUtil.makeDoubleStorage(this.relation.getDBIDs(), 30);
        DBIDIter iter = this.relation.iterDBIDs();
        while (iter.valid()) {
            NumberVector obj = (NumberVector)this.relation.get(iter);
            if (obj instanceof SparseNumberVector) {
                this.indexSparse(iter, (SparseNumberVector)obj);
            } else {
                this.indexDense(iter, obj);
            }
            iter.advance();
        }
        long count = 0L;
        for (ModifiableDoubleDBIDList column : this.index) {
            column.sort();
            count += (long)column.size();
        }
        double sparsity = (double)count / ((double)this.index.size() * (double)this.relation.size());
        if (sparsity > 0.2) {
            LOG.warning("Inverted list indexes only perform well for very sparse data. Your data set has a sparsity of " + sparsity);
        }
    }

    private void indexSparse(DBIDRef ref, SparseNumberVector obj) {
        double len = 0.0;
        int iter = obj.iter();
        while (obj.iterValid(iter)) {
            int dim = obj.iterDim(iter);
            double val = obj.iterDoubleValue(iter);
            if (val != 0.0 && val == val) {
                len += val * val;
                this.getOrCreateColumn(dim).add(val, ref);
            }
            iter = obj.iterAdvance(iter);
        }
        this.length.put(ref, len);
    }

    private void indexDense(DBIDRef ref, V obj) {
        double len = 0.0;
        int max = obj.getDimensionality();
        for (int dim = 0; dim < max; ++dim) {
            double val = obj.doubleValue(dim);
            if (val == 0.0 || val != val) continue;
            len += val * val;
            this.getOrCreateColumn(dim).add(val, ref);
        }
        this.length.put(ref, FastMath.sqrt(len));
    }

    private ModifiableDoubleDBIDList getOrCreateColumn(int dim) {
        while (dim >= this.index.size()) {
            this.index.add(DBIDUtil.newDistanceDBIDList());
        }
        return this.index.get(dim);
    }

    private double naiveQuerySparse(SparseNumberVector obj, WritableDoubleDataStore scores, HashSetModifiableDBIDs cands) {
        double len = 0.0;
        int iter = obj.iter();
        while (obj.iterValid(iter)) {
            int dim = obj.iterDim(iter);
            double val = obj.iterDoubleValue(iter);
            if (val != 0.0 && val == val) {
                len += val * val;
                if (dim < this.index.size()) {
                    ModifiableDoubleDBIDList column = this.index.get(dim);
                    DoubleDBIDListMIter n = column.iter();
                    while (n.valid()) {
                        scores.increment(n, n.doubleValue() * val);
                        cands.add(n);
                        n.advance();
                    }
                }
            }
            iter = obj.iterAdvance(iter);
        }
        return FastMath.sqrt(len);
    }

    private double naiveQueryDense(NumberVector obj, WritableDoubleDataStore scores, HashSetModifiableDBIDs cands) {
        double len = 0.0;
        int max = obj.getDimensionality();
        for (int dim = 0; dim < max; ++dim) {
            double val = obj.doubleValue(dim);
            if (val == 0.0 || val != val) continue;
            len += val * val;
            if (dim >= this.index.size()) continue;
            ModifiableDoubleDBIDList column = this.index.get(dim);
            DoubleDBIDListMIter n = column.iter();
            while (n.valid()) {
                scores.increment(n, n.doubleValue() * val);
                cands.add(n);
                n.advance();
            }
        }
        return FastMath.sqrt(len);
    }

    private double naiveQuery(V obj, WritableDoubleDataStore scores, HashSetModifiableDBIDs cands) {
        if (obj instanceof SparseNumberVector) {
            return this.naiveQuerySparse((SparseNumberVector)obj, scores, cands);
        }
        return this.naiveQueryDense((NumberVector)obj, scores, cands);
    }

    @Override
    public void logStatistics() {
        long count = 0L;
        for (ModifiableDoubleDBIDList column : this.index) {
            count += (long)column.size();
        }
        double sparsity = (double)count / ((double)this.index.size() * (double)this.relation.size());
        LOG.statistics(new DoubleStatistic(this.getClass().getName() + ".sparsity", sparsity));
    }

    @Override
    public KNNQuery<V> getKNNQuery(DistanceQuery<V> distanceQuery, Object ... hints) {
        DistanceFunction<V> df = distanceQuery.getDistanceFunction();
        if (df instanceof CosineDistanceFunction) {
            return new CosineKNNQuery(distanceQuery);
        }
        if (df instanceof ArcCosineDistanceFunction) {
            return new ArcCosineKNNQuery(distanceQuery);
        }
        return null;
    }

    @Override
    public RangeQuery<V> getRangeQuery(DistanceQuery<V> distanceQuery, Object ... hints) {
        DistanceFunction<V> df = distanceQuery.getDistanceFunction();
        if (df instanceof CosineDistanceFunction) {
            return new CosineRangeQuery(distanceQuery);
        }
        if (df instanceof ArcCosineDistanceFunction) {
            return new ArcCosineRangeQuery(distanceQuery);
        }
        return null;
    }

    @Override
    public String getLongName() {
        return "Inverted lists index";
    }

    @Override
    public String getShortName() {
        return "inverted-lists";
    }

    public static class Factory<V extends NumberVector>
    implements IndexFactory<V> {
        @Override
        public InMemoryInvertedIndex<V> instantiate(Relation<V> relation) {
            return new InMemoryInvertedIndex<V>(relation);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
        }

        public static class Parameterizer<V extends NumberVector>
        extends AbstractParameterizer {
            @Override
            protected Factory<V> makeInstance() {
                return new Factory();
            }
        }
    }

    protected class ArcCosineRangeQuery
    extends AbstractDistanceRangeQuery<V> {
        public ArcCosineRangeQuery(DistanceQuery<V> distanceQuery) {
            super(distanceQuery);
        }

        @Override
        public void getRangeForObject(V obj, double range, ModifiableDoubleDBIDList result) {
            HashSetModifiableDBIDs cands = DBIDUtil.newHashSet();
            WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(cands, 3, 0.0);
            double len = InMemoryInvertedIndex.this.naiveQuery(obj, scores, cands);
            double simrange = FastMath.cos(range) * len;
            DBIDMIter n = cands.iter();
            while (n.valid()) {
                double sim = scores.doubleValue(n) / InMemoryInvertedIndex.this.length.doubleValue(n);
                if (sim >= simrange) {
                    result.add(Math.acos(sim / len), n);
                }
                n.advance();
            }
        }
    }

    protected class CosineRangeQuery
    extends AbstractDistanceRangeQuery<V> {
        public CosineRangeQuery(DistanceQuery<V> distanceQuery) {
            super(distanceQuery);
        }

        @Override
        public void getRangeForObject(V obj, double range, ModifiableDoubleDBIDList result) {
            HashSetModifiableDBIDs cands = DBIDUtil.newHashSet();
            WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(cands, 3, 0.0);
            double len = InMemoryInvertedIndex.this.naiveQuery(obj, scores, cands);
            double simrange = (1.0 - range) * len;
            DBIDMIter n = cands.iter();
            while (n.valid()) {
                double sim = scores.doubleValue(n) / InMemoryInvertedIndex.this.length.doubleValue(n);
                if (sim >= simrange) {
                    result.add(1.0 - sim / len, n);
                }
                n.advance();
            }
        }
    }

    protected class ArcCosineKNNQuery
    extends AbstractDistanceKNNQuery<V> {
        public ArcCosineKNNQuery(DistanceQuery<V> distanceQuery) {
            super(distanceQuery);
        }

        @Override
        public KNNList getKNNForObject(V obj, int k) {
            HashSetModifiableDBIDs cands = DBIDUtil.newHashSet();
            WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(cands, 3, 0.0);
            double len = InMemoryInvertedIndex.this.naiveQuery(obj, scores, cands);
            KNNHeap heap = DBIDUtil.newHeap(k);
            DBIDMIter n = cands.iter();
            while (n.valid()) {
                double dist = Math.acos(scores.doubleValue(n) / (InMemoryInvertedIndex.this.length.doubleValue(n) * len));
                if (heap.getKNNDistance() >= dist) {
                    heap.insert(dist, n);
                }
                n.advance();
            }
            return heap.toKNNList();
        }
    }

    protected class CosineKNNQuery
    extends AbstractDistanceKNNQuery<V> {
        public CosineKNNQuery(DistanceQuery<V> distanceQuery) {
            super(distanceQuery);
        }

        @Override
        public KNNList getKNNForObject(V obj, int k) {
            HashSetModifiableDBIDs cands = DBIDUtil.newHashSet();
            WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(cands, 3, 0.0);
            double len = InMemoryInvertedIndex.this.naiveQuery(obj, scores, cands);
            KNNHeap heap = DBIDUtil.newHeap(k);
            DBIDMIter n = cands.iter();
            while (n.valid()) {
                double dist = 1.0 - scores.doubleValue(n) / (InMemoryInvertedIndex.this.length.doubleValue(n) * len);
                if (heap.getKNNDistance() >= dist) {
                    heap.insert(dist, n);
                }
                n.advance();
            }
            return heap.toKNNList();
        }
    }
}

