/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.lsh;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractRefiningIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.lsh.hashfamilies.LocalitySensitiveHashFunctionFamily;
import de.lmu.ifi.dbs.elki.index.lsh.hashfunctions.LocalitySensitiveHashFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;

public class InMemoryLSHIndex<V>
implements IndexFactory<V> {
    private static final Logging LOG = Logging.getLogger(InMemoryLSHIndex.class);
    LocalitySensitiveHashFunctionFamily<? super V> family;
    int l;
    int numberOfBuckets;

    public InMemoryLSHIndex(LocalitySensitiveHashFunctionFamily<? super V> family, int l, int numberOfBuckets) {
        this.family = family;
        this.l = l;
        this.numberOfBuckets = numberOfBuckets;
    }

    @Override
    public Instance instantiate(Relation<V> relation) {
        return new Instance(relation, this.family.generateHashFunctions(relation, this.l), this.numberOfBuckets);
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.family.getInputTypeRestriction();
    }

    public static class Parameterizer<V>
    extends AbstractParameterizer {
        public static final OptionID FAMILY_ID = new OptionID("lsh.family", "Hash function family to use for LSH.");
        public static final OptionID L_ID = new OptionID("lsh.tables", "Number of hash tables to use.");
        public static final OptionID BUCKETS_ID = new OptionID("lsh.buckets", "Number of hash buckets to use.");
        LocalitySensitiveHashFunctionFamily<? super V> family;
        int l;
        int numberOfBuckets;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter lP;
            super.makeOptions(config);
            ObjectParameter familyP = new ObjectParameter(FAMILY_ID, LocalitySensitiveHashFunctionFamily.class);
            if (config.grab(familyP)) {
                this.family = (LocalitySensitiveHashFunctionFamily)familyP.instantiateClass(config);
            }
            if (config.grab(lP = (IntParameter)new IntParameter(L_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.l = lP.intValue();
            }
            IntParameter bucketsP = (IntParameter)new IntParameter(BUCKETS_ID).setDefaultValue((Object)7919);
            bucketsP.addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(bucketsP)) {
                this.numberOfBuckets = bucketsP.intValue();
            }
        }

        @Override
        protected InMemoryLSHIndex<V> makeInstance() {
            return new InMemoryLSHIndex<V>(this.family, this.l, this.numberOfBuckets);
        }
    }

    public class Instance
    extends AbstractRefiningIndex<V>
    implements KNNIndex<V>,
    RangeIndex<V> {
        ArrayList<? extends LocalitySensitiveHashFunction<? super V>> hashfunctions;
        ArrayList<Int2ObjectOpenHashMap<DBIDs>> hashtables;
        private int numberOfBuckets;

        public Instance(Relation<V> relation, ArrayList<? extends LocalitySensitiveHashFunction<? super V>> hashfunctions, int numberOfBuckets) {
            super(relation);
            this.hashfunctions = hashfunctions;
            this.numberOfBuckets = numberOfBuckets;
        }

        @Override
        public String getLongName() {
            return "LSH index";
        }

        @Override
        public String getShortName() {
            return "lsh-index";
        }

        @Override
        public void initialize() {
            Int2ObjectOpenHashMap<DBIDs> table;
            int i;
            int numhash = this.hashfunctions.size();
            this.hashtables = new ArrayList(numhash);
            for (int i2 = 0; i2 < numhash; ++i2) {
                this.hashtables.add(new Int2ObjectOpenHashMap(this.numberOfBuckets));
            }
            double[] buf = new double[this.hashfunctions.get(0).getNumberOfProjections()];
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Building LSH index", this.relation.size(), LOG) : null;
            int expect = Math.max(2, (int)Math.ceil((double)this.relation.size() / (double)this.numberOfBuckets));
            DBIDIter iter = this.relation.getDBIDs().iter();
            while (iter.valid()) {
                Object obj = this.relation.get(iter);
                for (i = 0; i < numhash; ++i) {
                    LocalitySensitiveHashFunction hashfunc;
                    int hash;
                    int bucket;
                    table = this.hashtables.get(i);
                    DBIDs cur = table.get(bucket = (hash = (hashfunc = this.hashfunctions.get(i)).hashObject(obj, buf)) % this.numberOfBuckets);
                    if (cur == null) {
                        table.put(bucket, (DBIDs)DBIDUtil.deref(iter));
                        continue;
                    }
                    if (cur.size() > 1) {
                        ((ModifiableDBIDs)cur).add(iter);
                        continue;
                    }
                    ArrayModifiableDBIDs newbuck = DBIDUtil.newArray(expect);
                    newbuck.addDBIDs(cur);
                    newbuck.add(iter);
                    table.put(bucket, (DBIDs)newbuck);
                }
                LOG.incrementProcessed(progress);
                iter.advance();
            }
            LOG.ensureCompleted(progress);
            if (LOG.isStatistics()) {
                int min = Integer.MAX_VALUE;
                int max = 0;
                for (i = 0; i < numhash; ++i) {
                    table = this.hashtables.get(i);
                    for (DBIDs set : table.values()) {
                        int size = set.size();
                        min = size < min ? size : min;
                        max = size > max ? size : max;
                    }
                }
                LOG.statistics(new LongStatistic(this.getClass().getName() + ".fill.min", min));
                LOG.statistics(new LongStatistic(this.getClass().getName() + ".fill.max", max));
                LOG.statistics(new LongStatistic(this.getClass().getName() + ".hashtables", this.hashtables.size()));
            }
        }

        @Override
        public Logging getLogger() {
            return LOG;
        }

        @Override
        public KNNQuery<V> getKNNQuery(DistanceQuery<V> distanceQuery, Object ... hints) {
            for (Object hint : hints) {
                if (!"exact".equals(hint)) continue;
                return null;
            }
            DistanceFunction df = distanceQuery.getDistanceFunction();
            if (!InMemoryLSHIndex.this.family.isCompatible(df)) {
                return null;
            }
            return new LSHKNNQuery(distanceQuery);
        }

        @Override
        public RangeQuery<V> getRangeQuery(DistanceQuery<V> distanceQuery, Object ... hints) {
            for (Object hint : hints) {
                if (!"exact".equals(hint)) continue;
                return null;
            }
            DistanceFunction df = distanceQuery.getDistanceFunction();
            if (!InMemoryLSHIndex.this.family.isCompatible(df)) {
                return null;
            }
            return new LSHRangeQuery(distanceQuery);
        }

        protected DBIDs getCandidates(V obj) {
            ModifiableDBIDs candidates = null;
            int numhash = this.hashtables.size();
            double[] buf = new double[this.hashfunctions.get(0).getNumberOfProjections()];
            for (int i = 0; i < numhash; ++i) {
                LocalitySensitiveHashFunction hashfunc;
                int hash;
                int bucket;
                Int2ObjectOpenHashMap<DBIDs> table = this.hashtables.get(i);
                DBIDs cur = table.get(bucket = (hash = (hashfunc = this.hashfunctions.get(i)).hashObject(obj, buf)) % this.numberOfBuckets);
                if (cur == null) continue;
                if (candidates == null) {
                    candidates = DBIDUtil.newHashSet(cur.size() * numhash);
                }
                candidates.addDBIDs(cur);
            }
            return candidates == null ? DBIDUtil.EMPTYDBIDS : candidates;
        }

        protected class LSHRangeQuery
        extends AbstractRefiningIndex.AbstractRangeQuery {
            public LSHRangeQuery(DistanceQuery<V> distanceQuery) {
                super(Instance.this, distanceQuery);
            }

            @Override
            public void getRangeForObject(V obj, double range, ModifiableDoubleDBIDList result) {
                DBIDs candidates = Instance.this.getCandidates(obj);
                DBIDIter iter = candidates.iter();
                while (iter.valid()) {
                    double dist = this.distanceQuery.distance(obj, iter);
                    super.incRefinements(1);
                    if (dist <= range) {
                        result.add(dist, iter);
                    }
                    iter.advance();
                }
            }
        }

        protected class LSHKNNQuery
        extends AbstractRefiningIndex.AbstractKNNQuery {
            public LSHKNNQuery(DistanceQuery<V> distanceQuery) {
                super(Instance.this, distanceQuery);
            }

            @Override
            public KNNList getKNNForObject(V obj, int k) {
                DBIDs candidates = Instance.this.getCandidates(obj);
                KNNHeap heap = DBIDUtil.newHeap(k);
                DBIDIter iter = candidates.iter();
                while (iter.valid()) {
                    double dist = this.distanceQuery.distance(obj, iter);
                    super.incRefinements(1);
                    heap.insert(dist, iter);
                    iter.advance();
                }
                return heap.toKNNList();
            }
        }
    }
}

