/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.lsh.hashfamilies;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.random.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.index.lsh.hashfamilies.LocalitySensitiveHashFunctionFamily;
import de.lmu.ifi.dbs.elki.index.lsh.hashfunctions.LocalitySensitiveHashFunction;
import de.lmu.ifi.dbs.elki.index.lsh.hashfunctions.MultipleProjectionsLocalitySensitiveHashFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Random;

public abstract class AbstractProjectedHashFunctionFamily
implements LocalitySensitiveHashFunctionFamily<NumberVector> {
    protected RandomFactory random;
    protected RandomProjectionFamily proj;
    protected double width;
    protected int k;

    public AbstractProjectedHashFunctionFamily(RandomFactory random, RandomProjectionFamily proj, double width, int k) {
        this.random = random;
        this.proj = proj;
        this.width = width;
        this.k = k;
    }

    @Override
    public ArrayList<? extends LocalitySensitiveHashFunction<? super NumberVector>> generateHashFunctions(Relation<? extends NumberVector> relation, int l) {
        int dim = RelationUtil.dimensionality(relation);
        ArrayList<MultipleProjectionsLocalitySensitiveHashFunction> ps = new ArrayList<MultipleProjectionsLocalitySensitiveHashFunction>(l);
        Random rnd = this.random.getSingleThreadedRandom();
        for (int i = 0; i < l; ++i) {
            RandomProjectionFamily.Projection mat = this.proj.generateProjection(dim, this.k);
            ps.add(new MultipleProjectionsLocalitySensitiveHashFunction(mat, this.width, rnd));
        }
        return ps;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID RANDOM_ID = new OptionID("lsh.projection.random", "Random seed for generating the projections.");
        public static final OptionID WIDTH_ID = new OptionID("lsh.projection.width", "Bin width for random projections.");
        public static final OptionID NUMPROJ_ID = new OptionID("lsh.projection.projections", "Number of projections to use for each hash function.");
        RandomFactory random;
        double width;
        int k;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter lP;
            DoubleParameter widthP;
            super.makeOptions(config);
            RandomParameter randP = new RandomParameter(RANDOM_ID, RandomFactory.DEFAULT);
            if (config.grab(randP)) {
                this.random = (RandomFactory)randP.getValue();
            }
            if (config.grab(widthP = (DoubleParameter)new DoubleParameter(WIDTH_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.width = widthP.doubleValue();
            }
            if (config.grab(lP = (IntParameter)new IntParameter(NUMPROJ_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.k = lP.intValue();
            }
        }
    }
}

