/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.lsh.hashfamilies;

import de.lmu.ifi.dbs.elki.data.projection.random.GaussianRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.lsh.hashfamilies.AbstractProjectedHashFunctionFamily;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

@Reference(authors="M. Datar, N. Immorlica, P. Indyk, V. S. Mirrokni", title="Locality-sensitive hashing scheme based on p-stable distributions", booktitle="Proc. 20th Annual Symposium on Computational Geometry", url="https://doi.org/10.1145/997817.997857", bibkey="DBLP:conf/compgeom/DatarIIM04")
public class EuclideanHashFunctionFamily
extends AbstractProjectedHashFunctionFamily {
    public EuclideanHashFunctionFamily(RandomFactory random, double width, int k) {
        super(random, new GaussianRandomProjectionFamily(random), width, k);
    }

    @Override
    public boolean isCompatible(DistanceFunction<?> df) {
        return EuclideanDistanceFunction.class.isInstance(df);
    }

    public static class Parameterizer
    extends AbstractProjectedHashFunctionFamily.Parameterizer {
        @Override
        protected EuclideanHashFunctionFamily makeInstance() {
            return new EuclideanHashFunctionFamily(this.random, this.width, this.k);
        }
    }
}

