/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.lsh.hashfamilies;

import de.lmu.ifi.dbs.elki.data.projection.random.CauchyRandomProjectionFamily;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.ManhattanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.lsh.hashfamilies.AbstractProjectedHashFunctionFamily;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

@Reference(authors="M. Datar, N. Immorlica, P. Indyk, V. S. Mirrokni", title="Locality-sensitive hashing scheme based on p-stable distributions", booktitle="Proc. 20th Annual Symposium on Computational Geometry", url="https://doi.org/10.1145/997817.997857", bibkey="DBLP:conf/compgeom/DatarIIM04")
public class ManhattanHashFunctionFamily
extends AbstractProjectedHashFunctionFamily {
    public ManhattanHashFunctionFamily(RandomFactory random, double width, int k) {
        super(random, new CauchyRandomProjectionFamily(random), width, k);
    }

    @Override
    public boolean isCompatible(DistanceFunction<?> df) {
        return ManhattanDistanceFunction.class.isInstance(df);
    }

    public static class Parameterizer
    extends AbstractProjectedHashFunctionFamily.Parameterizer {
        @Override
        protected ManhattanHashFunctionFamily makeInstance() {
            return new ManhattanHashFunctionFamily(this.random, this.width, this.k);
        }
    }
}

