/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.lsh.hashfunctions;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.random.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.index.lsh.hashfunctions.LocalitySensitiveHashFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Random;

@Reference(authors="M. Datar, N. Immorlica, P. Indyk, V. S. Mirrokni", title="Locality-sensitive hashing scheme based on p-stable distributions", booktitle="Proc. 20th Annual Symposium on Computational Geometry", url="https://doi.org/10.1145/997817.997857", bibkey="DBLP:conf/compgeom/DatarIIM04")
public class MultipleProjectionsLocalitySensitiveHashFunction
implements LocalitySensitiveHashFunction<NumberVector> {
    RandomProjectionFamily.Projection projection;
    double[] shift;
    double iwidth;
    int[] randoms1;
    private static final long MASK32 = 0xFFFFFFFFL;

    public MultipleProjectionsLocalitySensitiveHashFunction(RandomProjectionFamily.Projection projection, double width, Random rnd) {
        this.projection = projection;
        this.iwidth = 1.0 / width;
        int num = projection.getOutputDimensionality();
        this.shift = new double[num];
        this.randoms1 = new int[num];
        for (int i = 0; i < num; ++i) {
            this.shift[i] = rnd.nextDouble() * width;
            this.randoms1[i] = (rnd.nextInt(0x10000D) << 16) + rnd.nextInt(1048573) + 1;
        }
    }

    @Override
    public int hashObject(NumberVector vec) {
        double[] proj = this.projection.project(vec);
        long t1sum = 0L;
        for (int i = 0; i < this.shift.length; ++i) {
            int ai = (int)Math.floor((proj[i] + this.shift[i]) * this.iwidth);
            t1sum += ((long)this.randoms1[i] & 0xFFFFFFFFL) * (long)ai;
        }
        return MultipleProjectionsLocalitySensitiveHashFunction.fastModPrime(t1sum);
    }

    @Override
    public int hashObject(NumberVector vec, double[] buf) {
        this.projection.project(vec, buf);
        long t1sum = 0L;
        for (int i = 0; i < this.shift.length; ++i) {
            int ai = (int)Math.floor((buf[i] + this.shift[i]) * this.iwidth);
            t1sum += ((long)this.randoms1[i] & 0xFFFFFFFFL) * (long)ai;
        }
        return MultipleProjectionsLocalitySensitiveHashFunction.fastModPrime(t1sum);
    }

    public static int fastModPrime(long data) {
        int high = (int)(data >>> 32);
        int alpha = (int)data + (high << 2 + high);
        if (alpha < 0 && alpha > -5) {
            alpha += 5;
        }
        return alpha;
    }

    @Override
    public int getNumberOfProjections() {
        return this.projection.getOutputDimensionality();
    }
}

