/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.fastoptics;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.jafama.FastMath;

@Reference(authors="J. Schneider, M. Vlachos", title="Fast parameterless density-based clustering via random projections", booktitle="Proc. 22nd ACM Int. Conf. on Information & Knowledge Management (CIKM 2013)", url="https://doi.org/10.1145/2505515.2505590", bibkey="DBLP:conf/cikm/SchneiderV13")
public class RandomProjectedNeighborsAndDensities<V extends NumberVector> {
    private static final Logging LOG = Logging.getLogger(RandomProjectedNeighborsAndDensities.class);
    private static final String PREFIX = RandomProjectedNeighborsAndDensities.class.getName();
    private static final int logOProjectionConst = 20;
    private static final float sizeTolerance = 0.6666667f;
    int minSplitSize;
    Relation<V> points;
    ArrayList<ArrayDBIDs> splitsets;
    DoubleDataStore[] projectedPoints;
    RandomFactory rnd;
    long distanceComputations;

    public RandomProjectedNeighborsAndDensities(RandomFactory rnd) {
        this.rnd = rnd;
    }

    public void computeSetsBounds(Relation<V> points, int minSplitSize, DBIDs ptList) {
        Object it;
        this.minSplitSize = minSplitSize;
        int size = points.size();
        int dim = RelationUtil.dimensionality(points);
        this.points = points;
        int nPointSetSplits = (int)(20.0 * MathUtil.log2(size * dim + 1));
        int nProject1d = (int)(20.0 * MathUtil.log2(size * dim + 1));
        LOG.statistics(new LongStatistic(PREFIX + ".partition-size", nPointSetSplits));
        LOG.statistics(new LongStatistic(PREFIX + ".num-projections", nProject1d));
        this.splitsets = new ArrayList();
        this.projectedPoints = new DoubleDataStore[nProject1d];
        DoubleDataStore[] tmpPro = new DoubleDataStore[nProject1d];
        Random rand = this.rnd.getSingleThreadedRandom();
        FiniteProgress projp = LOG.isVerbose() ? new FiniteProgress("Random projections", nProject1d, LOG) : null;
        for (int j = 0; j < nProject1d; ++j) {
            int i;
            double[] currRp = new double[dim];
            double sum = 0.0;
            for (i = 0; i < dim; ++i) {
                double fl;
                currRp[i] = fl = rand.nextDouble() - 0.5;
                sum += fl * fl;
            }
            sum = FastMath.sqrt(sum);
            i = 0;
            while (i < dim) {
                int n = i++;
                currRp[n] = currRp[n] / sum;
            }
            WritableDoubleDataStore currPro = DataStoreUtil.makeDoubleStorage(ptList, 2);
            it = ptList.iter();
            while (it.valid()) {
                NumberVector vecPt = (NumberVector)points.get((DBIDRef)it);
                double sum2 = 0.0;
                for (int i2 = 0; i2 < dim; ++i2) {
                    sum2 += currRp[i2] * vecPt.doubleValue(i2);
                }
                currPro.put((DBIDRef)it, sum2);
                it.advance();
            }
            this.projectedPoints[j] = currPro;
            LOG.incrementProcessed(projp);
        }
        LOG.ensureCompleted(projp);
        long numprod = (long)nProject1d * (long)ptList.size();
        LOG.statistics(new LongStatistic(PREFIX + ".num-scalar-products", numprod));
        IntArrayList proind = new IntArrayList(nProject1d);
        for (int j = 0; j < nProject1d; ++j) {
            proind.add(j);
        }
        FiniteProgress splitp = LOG.isVerbose() ? new FiniteProgress("Splitting data", nPointSetSplits, LOG) : null;
        for (int avgP = 0; avgP < nPointSetSplits; ++avgP) {
            int i;
            for (i = 0; i < nProject1d; ++i) {
                tmpPro[i] = this.projectedPoints[i];
            }
            for (i = 1; i < nProject1d; ++i) {
                int j = rand.nextInt(i);
                proind.set(i, proind.set(j, proind.getInt(i)));
            }
            it = proind.iterator();
            int i3 = 0;
            while (it.hasNext()) {
                int cind = it.nextInt();
                this.projectedPoints[cind] = tmpPro[i3];
                ++i3;
            }
            this.splitupNoSort(DBIDUtil.newArray(ptList), 0, size, 0, rand);
            LOG.incrementProcessed(splitp);
        }
        LOG.ensureCompleted(splitp);
    }

    public void splitupNoSort(ArrayModifiableDBIDs ind, int begin, int end, int dim, Random rand) {
        int nele = end - begin;
        DoubleDataStore tpro = this.projectedPoints[dim %= this.projectedPoints.length];
        if ((float)nele > (float)this.minSplitSize * 0.3333333f && (float)nele < (float)this.minSplitSize * 1.6666667f) {
            ind.sort(begin, end, new DataStoreUtil.AscendingByDoubleDataStore(tpro));
            this.splitsets.add(DBIDUtil.newArray(ind.slice(begin, end)));
        }
        if (nele > this.minSplitSize) {
            int minInd = this.splitRandomly(ind, begin, end, tpro, rand);
            int splitpos = minInd + 1;
            this.splitupNoSort(ind, begin, splitpos, dim + 1, rand);
            this.splitupNoSort(ind, splitpos, end, dim + 1, rand);
        }
    }

    public int splitRandomly(ArrayModifiableDBIDs ind, int begin, int end, DoubleDataStore tpro, Random rand) {
        int minInd;
        int nele = end - begin;
        DBIDArrayMIter it = ind.iter();
        double rs = tpro.doubleValue(it.seek(begin + rand.nextInt(nele)));
        int maxInd = end - 1;
        for (minInd = begin; minInd < maxInd; ++minInd) {
            double currEle = tpro.doubleValue(it.seek(minInd));
            if (!(currEle > rs)) continue;
            while (minInd < maxInd && tpro.doubleValue(it.seek(maxInd)) > rs) {
                --maxInd;
            }
            if (minInd == maxInd) break;
            ind.swap(minInd, maxInd);
            --maxInd;
        }
        if (minInd == end - 1) {
            minInd = begin + end >>> 1;
        }
        return minInd;
    }

    public int splitByDistance(ArrayModifiableDBIDs ind, int begin, int end, DoubleDataStore tpro, Random rand) {
        DBIDArrayMIter it = ind.iter();
        double rmin = 8.988465674311579E307;
        double rmax = -8.988465674311579E307;
        int minInd = begin;
        int maxInd = end - 1;
        it.seek(begin);
        while (it.getOffset() < end) {
            double currEle = tpro.doubleValue(it);
            rmin = Math.min(currEle, rmin);
            rmax = Math.max(currEle, rmax);
            it.advance();
        }
        if (rmin != rmax) {
            double rs = rmin + rand.nextDouble() * (rmax - rmin);
            while (minInd < maxInd) {
                double currEle = tpro.doubleValue(it.seek(minInd));
                if (currEle > rs) {
                    while (minInd < maxInd && tpro.doubleValue(it.seek(maxInd)) > rs) {
                        --maxInd;
                    }
                    if (minInd == maxInd) break;
                    ind.swap(minInd, maxInd);
                    --maxInd;
                }
                ++minInd;
            }
        } else {
            minInd = begin + end >>> 1;
        }
        return minInd;
    }

    public DataStore<? extends DBIDs> getNeighs() {
        DBIDs ids = this.points.getDBIDs();
        WritableDataStore<ModifiableDBIDs> neighs = DataStoreUtil.makeStorage(ids, 2, ModifiableDBIDs.class);
        DBIDIter it = ids.iter();
        while (it.valid()) {
            neighs.put(it, DBIDUtil.newHashSet());
            it.advance();
        }
        FiniteProgress splitp = LOG.isVerbose() ? new FiniteProgress("Processing splits for neighborhoods", this.splitsets.size(), LOG) : null;
        Iterator<ArrayDBIDs> it1 = this.splitsets.iterator();
        DBIDVar v = DBIDUtil.newVar();
        while (it1.hasNext()) {
            ArrayDBIDs pinSet = it1.next();
            int indoff = pinSet.size() >> 1;
            pinSet.assignVar(indoff, v);
            ((ModifiableDBIDs)neighs.get(v)).addDBIDs(pinSet);
            DBIDArrayIter it2 = pinSet.iter();
            while (it2.valid()) {
                ((ModifiableDBIDs)neighs.get(it2)).add(v);
                it2.advance();
            }
            LOG.incrementProcessed(splitp);
        }
        LOG.ensureCompleted(splitp);
        return neighs;
    }

    public DoubleDataStore computeAverageDistInSet() {
        WritableDoubleDataStore davg = DataStoreUtil.makeDoubleStorage(this.points.getDBIDs(), 2);
        WritableIntegerDataStore nDists = DataStoreUtil.makeIntegerStorage(this.points.getDBIDs(), 3);
        FiniteProgress splitp = LOG.isVerbose() ? new FiniteProgress("Processing splits for density estimation", this.splitsets.size(), LOG) : null;
        DBIDVar v = DBIDUtil.newVar();
        for (ArrayDBIDs pinSet : this.splitsets) {
            int len = pinSet.size();
            int indoff = len >> 1;
            pinSet.assignVar(indoff, v);
            NumberVector midpoint = (NumberVector)this.points.get(v);
            DBIDArrayIter it = pinSet.iter();
            while (it.getOffset() < len) {
                if (!DBIDUtil.equal(it, v)) {
                    double dist = EuclideanDistanceFunction.STATIC.distance((NumberVector)this.points.get(it), midpoint);
                    ++this.distanceComputations;
                    davg.increment(v, dist);
                    nDists.increment(v, 1);
                    davg.increment(it, dist);
                    nDists.increment(it, 1);
                }
                it.advance();
            }
            LOG.incrementProcessed(splitp);
        }
        LOG.ensureCompleted(splitp);
        DBIDIter it = this.points.getDBIDs().iter();
        while (it.valid()) {
            int count = nDists.intValue(it);
            double val = count == 0 ? (double)-0.1f : davg.doubleValue(it) / (double)count;
            davg.put((DBIDRef)it, val);
            it.advance();
        }
        nDists.destroy();
        return davg;
    }

    public void logStatistics() {
        LOG.statistics(new LongStatistic(PREFIX + ".distance-computations", this.distanceComputations));
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID RANDOM_ID = new OptionID("fastoptics.randomproj.seed", "Random seed for generating projections.");
        RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            RandomParameter rndP = new RandomParameter(RANDOM_ID);
            if (config.grab(rndP)) {
                this.rnd = (RandomFactory)rndP.getValue();
            }
        }

        @Override
        protected RandomProjectedNeighborsAndDensities<NumberVector> makeInstance() {
            return new RandomProjectedNeighborsAndDensities<NumberVector>(this.rnd);
        }
    }
}

