/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.PreprocessorKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.AbstractPreprocessorIndex;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractMaterializeKNNPreprocessor<O>
extends AbstractPreprocessorIndex<O, KNNList>
implements KNNIndex<O> {
    protected final int k;
    protected final DistanceFunction<? super O> distanceFunction;
    protected final DistanceQuery<O> distanceQuery;

    public AbstractMaterializeKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int k) {
        super(relation);
        this.k = k;
        this.distanceFunction = distanceFunction;
        this.distanceQuery = distanceFunction.instantiate(relation);
    }

    public DistanceQuery<O> getDistanceQuery() {
        return this.distanceQuery;
    }

    public int getK() {
        return this.k;
    }

    protected abstract void preprocess();

    public KNNList get(DBIDRef id) {
        if (this.storage == null) {
            if (this.getLogger().isDebugging()) {
                this.getLogger().debug("Running kNN preprocessor: " + this.getClass());
            }
            this.preprocess();
        }
        return (KNNList)this.storage.get(id);
    }

    void createStorage() {
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 2, KNNList.class);
    }

    @Override
    public void initialize() {
        if (this.storage != null) {
            throw new UnsupportedOperationException("Preprocessor already ran.");
        }
        if (this.relation.size() > 0) {
            this.preprocess();
        }
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distQ, Object ... hints) {
        if (distQ != this.distanceQuery && !this.distanceFunction.equals(distQ.getDistanceFunction())) {
            return null;
        }
        for (Object hint : hints) {
            if (!(hint instanceof Integer)) continue;
            if ((Integer)hint <= this.k) break;
            return null;
        }
        return new PreprocessorKNNQuery(this.relation, this);
    }

    public static abstract class Factory<O>
    implements IndexFactory<O> {
        public static final OptionID K_ID = new OptionID("materialize.k", "The number of nearest neighbors of an object to be materialized.");
        public static final OptionID DISTANCE_FUNCTION_ID = new OptionID("materialize.distance", "the distance function to materialize the nearest neighbors");
        protected int k;
        protected DistanceFunction<? super O> distanceFunction;

        public Factory(int k, DistanceFunction<? super O> distanceFunction) {
            this.k = k;
            this.distanceFunction = distanceFunction;
        }

        public abstract AbstractMaterializeKNNPreprocessor<O> instantiate(Relation<O> var1);

        public DistanceFunction<? super O> getDistanceFunction() {
            return this.distanceFunction;
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.distanceFunction.getInputTypeRestriction();
        }

        public static abstract class Parameterizer<O>
        extends AbstractParameterizer {
            protected int k;
            protected DistanceFunction<? super O> distanceFunction;

            @Override
            protected void makeOptions(Parameterization config) {
                ObjectParameter distanceFunctionP;
                super.makeOptions(config);
                IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
                if (config.grab(kP)) {
                    this.k = (Integer)kP.getValue();
                }
                if (config.grab(distanceFunctionP = new ObjectParameter(DISTANCE_FUNCTION_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class))) {
                    this.distanceFunction = (DistanceFunction)distanceFunctionP.instantiateClass(config);
                }
            }

            @Override
            protected abstract Factory<O> makeInstance();
        }
    }
}

