/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class CachedDoubleDistanceKNNPreprocessor<O>
extends AbstractMaterializeKNNPreprocessor<O> {
    private File filename;
    private static final Logging LOG = Logging.getLogger(CachedDoubleDistanceKNNPreprocessor.class);

    public CachedDoubleDistanceKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int k, File file) {
        super(relation, distanceFunction, k);
        this.filename = file;
    }

    @Override
    protected void preprocess() {
        this.createStorage();
        try (RandomAccessFile file = new RandomAccessFile(this.filename, "rw");
             FileChannel channel = file.getChannel();){
            int header = file.readInt();
            if (header != -893108964) {
                throw new AbortException("Cache magic number does not match.");
            }
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 4L, file.length() - 4L);
            DBIDIter iter = this.relation.iterDBIDs();
            while (iter.valid()) {
                int dbid = ByteArrayUtil.readUnsignedVarint(buffer);
                int nnsize = ByteArrayUtil.readUnsignedVarint(buffer);
                if (nnsize < this.k) {
                    throw new AbortException("kNN cache contains fewer than k objects!");
                }
                KNNHeap knn = DBIDUtil.newHeap(this.k);
                for (int i = 0; i < nnsize; ++i) {
                    int nid = ByteArrayUtil.readUnsignedVarint(buffer);
                    double dist = buffer.getDouble();
                    knn.insert(dist, DBIDUtil.importInteger(nid));
                }
                this.storage.put(DBIDUtil.importInteger(dbid), knn.toKNNList());
                iter.advance();
            }
            if (buffer.hasRemaining()) {
                LOG.warning("kNN cache has " + buffer.remaining() + " bytes remaining!");
            }
        }
        catch (IOException e) {
            throw new AbortException("I/O error in loading kNN cache: " + e.getMessage(), e);
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "cached-knn";
    }

    @Override
    public String getShortName() {
        return "cached-knn";
    }

    @Override
    public void logStatistics() {
    }

    public static class Factory<O>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        private File filename;

        public Factory(int k, DistanceFunction<? super O> distanceFunction, File filename) {
            super(k, distanceFunction);
            this.filename = filename;
        }

        @Override
        public CachedDoubleDistanceKNNPreprocessor<O> instantiate(Relation<O> relation) {
            CachedDoubleDistanceKNNPreprocessor<O> instance = new CachedDoubleDistanceKNNPreprocessor<O>(relation, this.distanceFunction, this.k, this.filename);
            return instance;
        }

        public static class Parameterizer<O>
        extends AbstractMaterializeKNNPreprocessor.Factory.Parameterizer<O> {
            public static final OptionID CACHE_ID = new OptionID("external.knnfile", "Filename with the precomputed k nearest neighbors.");
            private File filename;

            @Override
            protected void makeOptions(Parameterization config) {
                super.makeOptions(config);
                FileParameter cpar = new FileParameter(CACHE_ID, FileParameter.FileType.INPUT_FILE);
                if (config.grab(cpar)) {
                    this.filename = (File)cpar.getValue();
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.k, this.distanceFunction, this.filename);
            }
        }
    }
}

