/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.PreprocessorRKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.MaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

@Title(value="Materialize kNN and RkNN Neighborhood preprocessor")
@Description(value="Materializes the k nearest neighbors and the reverse k nearest neighbors of objects of a database.")
public class MaterializeKNNAndRKNNPreprocessor<O>
extends MaterializeKNNPreprocessor<O>
implements RKNNIndex<O> {
    private static final Logging LOG = Logging.getLogger(MaterializeKNNAndRKNNPreprocessor.class);
    private WritableDataStore<TreeSet<DoubleDBIDPair>> materialized_RkNN;

    public MaterializeKNNAndRKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int k) {
        super(relation, distanceFunction, k);
    }

    @Override
    protected void preprocess() {
        this.createStorage();
        this.materialized_RkNN = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 2, TreeSet.class);
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Materializing k nearest neighbors and reverse k nearest neighbors (k=" + this.k + ")", this.relation.size(), this.getLogger()) : null;
        this.materializeKNNAndRKNNs(DBIDUtil.ensureArray(this.relation.getDBIDs()), progress);
    }

    private void materializeKNNAndRKNNs(ArrayDBIDs ids, FiniteProgress progress) {
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            if (this.materialized_RkNN.get(iter) == null) {
                this.materialized_RkNN.put(iter, new TreeSet());
            }
            iter.advance();
        }
        List<KNNList> kNNList = this.knnQuery.getKNNForBulkDBIDs(ids, this.k);
        DBIDArrayIter id = ids.iter();
        while (id.valid()) {
            KNNList kNNs = kNNList.get(id.getOffset());
            this.storage.put(id, kNNs);
            DoubleDBIDListIter iter2 = kNNs.iter();
            while (iter2.valid()) {
                ((TreeSet)this.materialized_RkNN.get(iter2)).add(DBIDUtil.newPair(iter2.doubleValue(), (DBIDRef)id));
                iter2.advance();
            }
            LOG.incrementProcessed(progress);
            id.advance();
        }
        LOG.ensureCompleted(progress);
    }

    @Override
    protected void objectsInserted(DBIDs ids) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress(3) : null;
        ArrayDBIDs aids = DBIDUtil.ensureArray(ids);
        LOG.beginStep(stepprog, 1, "New insertions ocurred, materialize their new kNNs and RkNNs.");
        this.materializeKNNAndRKNNs(aids, null);
        LOG.beginStep(stepprog, 2, "New insertions ocurred, update the affected kNNs and RkNNs.");
        ArrayDBIDs rkNN_ids = this.updateKNNsAndRkNNs(ids);
        LOG.beginStep(stepprog, 3, "New insertions ocurred, inform listeners.");
        this.fireKNNsInserted(ids, rkNN_ids);
        LOG.ensureCompleted(stepprog);
    }

    private ArrayDBIDs updateKNNsAndRkNNs(DBIDs ids) {
        ArrayModifiableDBIDs rkNN_ids = DBIDUtil.newArray();
        ModifiableDBIDs oldids = DBIDUtil.difference(this.relation.getDBIDs(), ids);
        DBIDIter id = oldids.iter();
        while (id.valid()) {
            KNNList oldkNNs = (KNNList)this.storage.get(id);
            double knnDist = oldkNNs.getKNNDistance();
            KNNHeap heap = null;
            DBIDIter newid = ids.iter();
            while (newid.valid()) {
                double dist = this.distanceQuery.distance((DBIDRef)id, (DBIDRef)newid);
                if (dist <= knnDist) {
                    heap = heap != null ? heap : DBIDUtil.newHeap(oldkNNs);
                    heap.insert(dist, newid);
                }
                newid.advance();
            }
            if (heap != null) {
                KNNList newkNNs = heap.toKNNList();
                this.storage.put(id, newkNNs);
                ModifiableDoubleDBIDList added = DBIDUtil.newDistanceDBIDList();
                ModifiableDoubleDBIDList removed = DBIDUtil.newDistanceDBIDList();
                DoubleDBIDListIter olditer = oldkNNs.iter();
                DoubleDBIDListIter newiter = newkNNs.iter();
                while (olditer.valid() && newiter.valid()) {
                    double oldd;
                    if (DBIDUtil.equal(olditer, newiter)) {
                        olditer.advance();
                        newiter.advance();
                        continue;
                    }
                    double newd = newiter.doubleValue();
                    if (newd < (oldd = olditer.doubleValue()) || newd == oldd && !oldkNNs.contains(newiter)) {
                        added.add(newiter.doubleValue(), newiter);
                        newiter.advance();
                        continue;
                    }
                    if (oldd < newd || oldd == newd && !newkNNs.contains(olditer)) {
                        removed.add(olditer.doubleValue(), olditer);
                        olditer.advance();
                        continue;
                    }
                    throw new IllegalStateException("Unexpected third case, needs debug!");
                }
                while (olditer.valid()) {
                    removed.add(olditer.doubleValue(), olditer);
                    olditer.advance();
                }
                while (newiter.valid()) {
                    added.add(newiter.doubleValue(), newiter);
                    newiter.advance();
                }
                DoubleDBIDListMIter newnn = added.iter();
                while (newnn.valid()) {
                    ((TreeSet)this.materialized_RkNN.get(newnn)).add(DBIDUtil.newPair(newnn.doubleValue(), (DBIDRef)id));
                    newnn.advance();
                }
                DoubleDBIDListMIter oldnn = removed.iter();
                while (oldnn.valid()) {
                    ((TreeSet)this.materialized_RkNN.get(oldnn)).remove(DBIDUtil.newPair(oldnn.doubleValue(), (DBIDRef)id));
                    oldnn.advance();
                }
                rkNN_ids.add(id);
            }
            id.advance();
        }
        return rkNN_ids;
    }

    @Override
    protected void objectsRemoved(DBIDs ids) {
        Object it;
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress(3) : null;
        SetDBIDs valid = DBIDUtil.ensureSet(this.distanceQuery.getRelation().getDBIDs());
        ArrayDBIDs aids = DBIDUtil.ensureArray(ids);
        LOG.beginStep(stepprog, 1, "New deletions ocurred, remove their materialized kNNs and RkNNs.");
        ArrayList kNNs = new ArrayList(ids.size());
        ArrayList rkNNs = new ArrayList(ids.size());
        DBIDArrayIter iter = aids.iter();
        while (iter.valid()) {
            kNNs.add(this.storage.get(iter));
            DoubleDBIDListIter it2 = ((KNNList)this.storage.get(iter)).iter();
            while (it2.valid()) {
                if (!valid.contains(it2) && !ids.contains(it2)) {
                    LOG.warning("False kNN: " + it2);
                }
                it2.advance();
            }
            this.storage.delete(iter);
            rkNNs.add(this.materialized_RkNN.get(iter));
            for (DoubleDBIDPair it3 : (TreeSet)this.materialized_RkNN.get(iter)) {
                if (valid.contains(it3) || ids.contains(it3)) continue;
                LOG.warning("False RkNN: " + it3);
            }
            this.materialized_RkNN.delete(iter);
            iter.advance();
        }
        ArrayDBIDs kNN_ids = this.affectedkNN(kNNs, aids);
        ArrayDBIDs rkNN_ids = this.affectedRkNN(rkNNs, aids);
        LOG.beginStep(stepprog, 2, "New deletions ocurred, update the affected kNNs and RkNNs.");
        List<KNNList> kNNList = this.knnQuery.getKNNForBulkDBIDs(rkNN_ids, this.k);
        DBIDArrayIter reknn = rkNN_ids.iter();
        while (reknn.valid()) {
            KNNList rknnlist = kNNList.get(reknn.getOffset());
            if (rknnlist == null && !valid.contains(reknn)) {
                LOG.warning("BUG in online kNN/RkNN maintainance: " + DBIDUtil.toString(reknn) + " no longer in database.");
            } else {
                assert (rknnlist != null);
                this.storage.put(reknn, rknnlist);
                it = rknnlist.iter();
                while (it.valid()) {
                    ((TreeSet)this.materialized_RkNN.get((DBIDRef)it)).add(DBIDUtil.newPair(it.doubleValue(), (DBIDRef)reknn));
                    it.advance();
                }
            }
            reknn.advance();
        }
        SetDBIDs idsSet = DBIDUtil.ensureSet(ids);
        DBIDArrayIter nn = kNN_ids.iter();
        while (nn.valid()) {
            TreeSet rkNN = (TreeSet)this.materialized_RkNN.get(nn);
            it = rkNN.iterator();
            while (it.hasNext()) {
                if (!idsSet.contains((DBIDRef)it.next())) continue;
                it.remove();
            }
            nn.advance();
        }
        LOG.beginStep(stepprog, 3, "New deletions ocurred, inform listeners.");
        this.fireKNNsRemoved(ids, rkNN_ids);
        LOG.ensureCompleted(stepprog);
    }

    protected ArrayDBIDs affectedkNN(List<? extends KNNList> extract, DBIDs remove) {
        HashSetModifiableDBIDs ids = DBIDUtil.newHashSet();
        for (KNNList kNNList : extract) {
            DoubleDBIDListIter iter = kNNList.iter();
            while (iter.valid()) {
                ids.add(iter);
                iter.advance();
            }
        }
        ids.removeDBIDs(remove);
        return DBIDUtil.newArray(ids);
    }

    protected ArrayDBIDs affectedRkNN(List<? extends Collection<DoubleDBIDPair>> extract, DBIDs remove) {
        HashSetModifiableDBIDs ids = DBIDUtil.newHashSet();
        for (Collection<DoubleDBIDPair> collection : extract) {
            for (DoubleDBIDPair drp : collection) {
                ids.add(drp);
            }
        }
        ids.removeDBIDs(remove);
        return DBIDUtil.newArray(ids);
    }

    public KNNList getKNN(DBID id) {
        return (KNNList)this.storage.get(id);
    }

    public DoubleDBIDList getRKNN(DBIDRef id) {
        TreeSet rKNN = (TreeSet)this.materialized_RkNN.get(id);
        if (rKNN == null) {
            return null;
        }
        ModifiableDoubleDBIDList ret = DBIDUtil.newDistanceDBIDList(rKNN.size());
        for (DoubleDBIDPair pair : rKNN) {
            ret.add(pair);
        }
        ret.sort();
        return ret;
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (!this.distanceFunction.equals(distanceQuery.getDistanceFunction())) {
            return null;
        }
        for (Object hint : hints) {
            if (!(hint instanceof Integer)) continue;
            if ((Integer)hint <= this.k) break;
            return null;
        }
        return new PreprocessorRKNNQuery(this.relation, this);
    }

    @Override
    public String getLongName() {
        return "kNN and RkNN Preprocessor";
    }

    @Override
    public String getShortName() {
        return "knn and rknn preprocessor";
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory<O>
    extends MaterializeKNNPreprocessor.Factory<O> {
        public Factory(int k, DistanceFunction<? super O> distanceFunction) {
            super(k, distanceFunction);
        }

        @Override
        public MaterializeKNNAndRKNNPreprocessor<O> instantiate(Relation<O> relation) {
            MaterializeKNNAndRKNNPreprocessor<O> instance = new MaterializeKNNAndRKNNPreprocessor<O>(relation, this.distanceFunction, this.k);
            return instance;
        }

        public static class Parameterizer<O>
        extends MaterializeKNNPreprocessor.Factory.Parameterizer<O> {
            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.k, this.distanceFunction);
            }
        }
    }
}

