/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.KNNChangeEvent;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.KNNListener;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.List;
import javax.swing.event.EventListenerList;

@Title(value="Materialize kNN Neighborhood preprocessor")
@Description(value="Materializes the k nearest neighbors of objects of a database.")
@Alias(value={"de.lmu.ifi.dbs.elki.preprocessing.MaterializeKNNPreprocessor"})
public class MaterializeKNNPreprocessor<O>
extends AbstractMaterializeKNNPreprocessor<O>
implements DynamicIndex {
    private static final Logging LOG = Logging.getLogger(MaterializeKNNPreprocessor.class);
    private static final boolean usebulk = false;
    protected final KNNQuery<O> knnQuery;
    protected final EventListenerList listenerList = new EventListenerList();

    public MaterializeKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int k) {
        super(relation, distanceFunction, k);
        this.knnQuery = relation.getKNNQuery(this.distanceQuery, k, "need_bulk", "heavy", "no-cache");
    }

    @Override
    protected void preprocess() {
        Logging log = this.getLogger();
        this.createStorage();
        ArrayDBIDs ids = DBIDUtil.ensureArray(this.relation.getDBIDs());
        if (log.isStatistics()) {
            log.statistics(new LongStatistic(this.getClass().getName() + ".k", this.k));
        }
        Duration duration = log.isStatistics() ? log.newDuration(this.getClass().getName() + ".precomputation-time").begin() : null;
        FiniteProgress progress = this.getLogger().isVerbose() ? new FiniteProgress("Materializing k nearest neighbors (k=" + this.k + ")", ids.size(), this.getLogger()) : null;
        Object kNNList = null;
        boolean ismetric = this.getDistanceQuery().getDistanceFunction().isMetric();
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            if (ismetric && this.storage.get(iter) != null) {
                log.incrementProcessed(progress);
            } else {
                KNNList knn = this.knnQuery.getKNNForDBID(iter, this.k);
                this.storage.put(iter, knn);
                if (ismetric) {
                    DoubleDBIDListIter it = knn.iter();
                    while (it.valid() && it.doubleValue() == 0.0) {
                        this.storage.put(it, knn);
                        it.advance();
                    }
                }
                log.incrementProcessed(progress);
            }
            iter.advance();
        }
        log.ensureCompleted(progress);
        if (duration != null) {
            log.statistics(duration.end());
        }
    }

    @Override
    public final void insert(DBIDRef id) {
        this.objectsInserted(DBIDUtil.deref(id));
    }

    @Override
    public void insertAll(DBIDs ids) {
        if (this.storage == null && ids.size() > 0) {
            this.preprocess();
        } else {
            this.objectsInserted(ids);
        }
    }

    @Override
    public boolean delete(DBIDRef id) {
        this.objectsRemoved(DBIDUtil.deref(id));
        return true;
    }

    @Override
    public void deleteAll(DBIDs ids) {
        this.objectsRemoved(ids);
    }

    protected void objectsInserted(DBIDs ids) {
        Logging log = this.getLogger();
        StepProgress stepprog = log.isVerbose() ? new StepProgress(3) : null;
        ArrayDBIDs aids = DBIDUtil.ensureArray(ids);
        log.beginStep(stepprog, 1, "New insertions ocurred, materialize their new kNNs.");
        List<KNNList> kNNList = this.knnQuery.getKNNForBulkDBIDs(aids, this.k);
        DBIDArrayIter iter = aids.iter();
        for (int i = 0; i < aids.size(); ++i) {
            this.storage.put(iter, kNNList.get(i));
            iter.advance();
        }
        log.beginStep(stepprog, 2, "New insertions ocurred, update the affected kNNs.");
        ArrayDBIDs rkNN_ids = this.updateKNNsAfterInsertion(ids);
        log.beginStep(stepprog, 3, "New insertions ocurred, inform listeners.");
        this.fireKNNsInserted(ids, rkNN_ids);
        log.setCompleted(stepprog);
    }

    private ArrayDBIDs updateKNNsAfterInsertion(DBIDs ids) {
        ArrayModifiableDBIDs rkNN_ids = DBIDUtil.newArray();
        ModifiableDBIDs oldids = DBIDUtil.difference(this.relation.getDBIDs(), ids);
        DBIDIter iter = oldids.iter();
        while (iter.valid()) {
            KNNList kNNs = (KNNList)this.storage.get(iter);
            double knnDist = kNNs.getKNNDistance();
            KNNHeap heap = null;
            DBIDIter iter2 = ids.iter();
            while (iter2.valid()) {
                double dist = this.distanceQuery.distance((DBIDRef)iter, (DBIDRef)iter2);
                if (dist <= knnDist) {
                    heap = heap != null ? heap : DBIDUtil.newHeap(kNNs);
                    heap.insert(dist, iter2);
                }
                iter2.advance();
            }
            if (heap != null) {
                kNNs = heap.toKNNList();
                this.storage.put(iter, kNNs);
                rkNN_ids.add(iter);
            }
            iter.advance();
        }
        return rkNN_ids;
    }

    private ArrayDBIDs updateKNNsAfterDeletion(DBIDs ids) {
        SetDBIDs idsSet = DBIDUtil.ensureSet(ids);
        ArrayModifiableDBIDs rkNN_ids = DBIDUtil.newArray();
        DBIDIter iditer = this.relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList kNNs = (KNNList)this.storage.get(iditer);
            DoubleDBIDListIter it = kNNs.iter();
            while (it.valid()) {
                if (idsSet.contains(it)) {
                    rkNN_ids.add(iditer);
                    break;
                }
                it.advance();
            }
            iditer.advance();
        }
        List<KNNList> kNNList = this.knnQuery.getKNNForBulkDBIDs(rkNN_ids, this.k);
        DBIDArrayMIter iter = rkNN_ids.iter();
        for (int i = 0; i < rkNN_ids.size(); ++i) {
            this.storage.put(iter, kNNList.get(i));
            iter.advance();
        }
        return rkNN_ids;
    }

    protected void objectsRemoved(DBIDs ids) {
        Logging log = this.getLogger();
        StepProgress stepprog = log.isVerbose() ? new StepProgress(3) : null;
        log.beginStep(stepprog, 1, "New deletions ocurred, remove their materialized kNNs.");
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            this.storage.delete(iter);
            iter.advance();
        }
        log.beginStep(stepprog, 2, "New deletions ocurred, update the affected kNNs.");
        ArrayDBIDs rkNN_ids = this.updateKNNsAfterDeletion(ids);
        log.beginStep(stepprog, 3, "New deletions ocurred, inform listeners.");
        this.fireKNNsRemoved(ids, rkNN_ids);
        log.ensureCompleted(stepprog);
    }

    protected void fireKNNsInserted(DBIDs insertions, DBIDs updates) {
        KNNChangeEvent e = new KNNChangeEvent(this, KNNChangeEvent.Type.INSERT, insertions, updates);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KNNListener.class) continue;
            ((KNNListener)listeners[i + 1]).kNNsChanged(e);
        }
    }

    protected void fireKNNsRemoved(DBIDs removals, DBIDs updates) {
        KNNChangeEvent e = new KNNChangeEvent(this, KNNChangeEvent.Type.DELETE, removals, updates);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KNNListener.class) continue;
            ((KNNListener)listeners[i + 1]).kNNsChanged(e);
        }
    }

    public void addKNNListener(KNNListener l) {
        this.listenerList.add(KNNListener.class, l);
    }

    public void removeKNNListener(KNNListener l) {
        this.listenerList.remove(KNNListener.class, l);
    }

    @Override
    public String getLongName() {
        return "kNN Preprocessor";
    }

    @Override
    public String getShortName() {
        return "knn preprocessor";
    }

    @Override
    public void logStatistics() {
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory<O>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        public Factory(int k, DistanceFunction<? super O> distanceFunction) {
            super(k, distanceFunction);
        }

        @Override
        public MaterializeKNNPreprocessor<O> instantiate(Relation<O> relation) {
            MaterializeKNNPreprocessor<O> instance = new MaterializeKNNPreprocessor<O>(relation, this.distanceFunction, this.k);
            return instance;
        }

        public static class Parameterizer<O>
        extends AbstractMaterializeKNNPreprocessor.Factory.Parameterizer<O> {
            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.k, this.distanceFunction);
            }
        }
    }
}

