/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreFactory;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.HashSetDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;

@Reference(authors="W. Dong, C. Moses, K. Li", title="Efficient k-nearest neighbor graph construction for generic similarity measures", booktitle="Proc. 20th Int. Conf. on World Wide Web (WWW'11)", url="https://doi.org/10.1145/1963405.1963487", bibkey="DBLP:conf/www/DongCL11")
public class NNDescent<O>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(NNDescent.class);
    private String prefix = this.getClass().getCanonicalName();
    private final RandomFactory rnd;
    private double delta = 0.001;
    private double rho = 1.0;
    private int iterations = 100;
    private boolean noInitialNeighbors;
    private WritableDataStore<KNNHeap> store;

    public NNDescent(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int k, RandomFactory rnd, double delta, double rho, boolean noInitialNeighbors, int iterations) {
        super(relation, distanceFunction, k);
        this.rnd = rnd;
        this.delta = delta;
        this.rho = rho;
        this.noInitialNeighbors = noInitialNeighbors;
        this.iterations = iterations;
    }

    @Override
    protected void preprocess() {
        int iter;
        DBIDs ids = this.relation.getDBIDs();
        long starttime = System.currentTimeMillis();
        IndefiniteProgress progress = LOG.isVerbose() ? new IndefiniteProgress("KNNGraph iteration", LOG) : null;
        int internal_k = this.k - 1;
        this.store = DataStoreFactory.FACTORY.makeStorage(ids, 3, KNNHeap.class);
        WritableDataStore<HashSetModifiableDBIDs> newReverseNeighbors = DataStoreFactory.FACTORY.makeStorage(ids, 3, HashSetModifiableDBIDs.class);
        WritableDataStore<HashSetModifiableDBIDs> oldReverseNeighbors = DataStoreFactory.FACTORY.makeStorage(ids, 3, HashSetModifiableDBIDs.class);
        WritableDataStore<HashSetModifiableDBIDs> sampleNewNeighbors = DataStoreFactory.FACTORY.makeStorage(ids, 3, HashSetModifiableDBIDs.class);
        WritableDataStore<HashSetModifiableDBIDs> flag = DataStoreFactory.FACTORY.makeStorage(ids, 3, HashSetModifiableDBIDs.class);
        DBIDIter iditer = ids.iter();
        while (iditer.valid()) {
            this.store.put(iditer, DBIDUtil.newHeap(internal_k));
            newReverseNeighbors.put(iditer, DBIDUtil.newHashSet());
            oldReverseNeighbors.put(iditer, DBIDUtil.newHashSet());
            iditer.advance();
        }
        int items = (int)Math.ceil(this.rho * (double)internal_k);
        long counter_all = 0L;
        DBIDIter iditer2 = ids.iter();
        while (iditer2.valid()) {
            ModifiableDBIDs sampleNew = DBIDUtil.randomSampleExcept(ids, (DBIDRef)iditer2, items, this.rnd);
            sampleNewNeighbors.put(iditer2, DBIDUtil.newHashSet(sampleNew));
            ModifiableDBIDs sampleRev = DBIDUtil.randomSampleExcept(ids, (DBIDRef)iditer2, items, this.rnd);
            newReverseNeighbors.put(iditer2, DBIDUtil.newHashSet(sampleRev));
            flag.put(iditer2, DBIDUtil.newHashSet());
            if (!this.noInitialNeighbors) {
                HashSetModifiableDBIDs flags = (HashSetModifiableDBIDs)flag.get(iditer2);
                DBIDMIter siter = sampleNew.iter();
                while (siter.valid()) {
                    if (this.add(iditer2, siter, this.distanceQuery.distance((DBIDRef)iditer2, (DBIDRef)siter))) {
                        flags.add(siter);
                    }
                    siter.advance();
                }
                counter_all += (long)sampleNew.size();
            }
            iditer2.advance();
        }
        int size = this.relation.size();
        double rate = 0.0;
        for (iter = 0; iter < this.iterations; ++iter) {
            long counter = 0L;
            DBIDIter iditer3 = this.relation.iterDBIDs();
            while (iditer3.valid()) {
                HashSetModifiableDBIDs newNeighbors = (HashSetModifiableDBIDs)flag.get(iditer3);
                HashSetModifiableDBIDs oldNeighbors = DBIDUtil.newHashSet();
                KNNHeap heap = (KNNHeap)this.store.get(iditer3);
                DoubleDBIDListIter heapiter = heap.unorderedIterator();
                while (heapiter.valid()) {
                    if (!newNeighbors.contains(heapiter)) {
                        oldNeighbors.add(heapiter);
                    }
                    heapiter.advance();
                }
                HashSetModifiableDBIDs sampleNew = (HashSetModifiableDBIDs)sampleNewNeighbors.get(iditer3);
                HashSetModifiableDBIDs newRev = (HashSetModifiableDBIDs)newReverseNeighbors.get(iditer3);
                newRev.removeDBIDs(sampleNew);
                this.boundSize(newRev, items);
                HashSetModifiableDBIDs oldRev = (HashSetModifiableDBIDs)oldReverseNeighbors.get(iditer3);
                oldRev.removeDBIDs(oldNeighbors);
                this.boundSize(oldRev, items);
                counter += (long)this.processNewNeighbors(flag, sampleNew, oldNeighbors, newRev, oldRev);
                iditer3.advance();
            }
            counter_all += counter;
            if (LOG.isStatistics()) {
                LOG.statistics(new DoubleStatistic(this.prefix + ".scan-rate", (double)counter_all * 0.5 / (double)((long)size * ((long)size - 1L))));
            }
            int t = this.sampleNew(ids, sampleNewNeighbors, flag, items);
            this.clearAll(ids, newReverseNeighbors);
            this.clearAll(ids, oldReverseNeighbors);
            this.reverse(sampleNewNeighbors, newReverseNeighbors, oldReverseNeighbors);
            rate = (double)t / (double)(internal_k * size);
            if (LOG.isStatistics()) {
                LOG.statistics(new DoubleStatistic(this.prefix + ".update-rate", rate));
            }
            if ((double)counter < this.delta * (double)internal_k * (double)size) {
                LOG.verbose("KNNGraph terminated because we performaned delta*k*size distance computations.");
                break;
            }
            if (rate < this.delta) {
                LOG.verbose("KNNGraph terminated because update rate got smaller than delta.");
                break;
            }
            LOG.incrementProcessed(progress);
        }
        if (LOG.isVerbose() && iter == this.iterations) {
            LOG.verbose("KNNGraph terminated because the maximum number of iterations was reached.");
        }
        LOG.setCompleted(progress);
        this.storage = DataStoreFactory.FACTORY.makeStorage(ids, 30, KNNList.class);
        DBIDIter iditer4 = this.relation.iterDBIDs();
        while (iditer4.valid()) {
            KNNHeap tempHeap = DBIDUtil.newHeap(this.k);
            KNNHeap heap = (KNNHeap)this.store.get(iditer4);
            tempHeap.insert(0.0, iditer4);
            DoubleDBIDListIter heapiter = heap.unorderedIterator();
            while (heapiter.valid()) {
                tempHeap.insert(heapiter.doubleValue(), heapiter);
                heapiter.advance();
            }
            this.storage.put(iditer4, tempHeap.toKNNList());
            iditer4.advance();
        }
        long end = System.currentTimeMillis();
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(this.prefix + ".construction-time.ms", end - starttime));
        }
    }

    private void clearAll(DBIDs ids, WritableDataStore<HashSetModifiableDBIDs> sets) {
        DBIDIter it = ids.iter();
        while (it.valid()) {
            ((HashSetModifiableDBIDs)sets.get(it)).clear();
            it.advance();
        }
    }

    private void boundSize(HashSetModifiableDBIDs set, int items) {
        if (set.size() > items) {
            ModifiableDBIDs sample = DBIDUtil.randomSample((DBIDs)set, items, this.rnd);
            set.clear();
            set.addDBIDs(sample);
        }
    }

    private int processNewNeighbors(WritableDataStore<HashSetModifiableDBIDs> flag, HashSetModifiableDBIDs newFwd, HashSetModifiableDBIDs oldFwd, HashSetModifiableDBIDs newRev, HashSetModifiableDBIDs oldRev) {
        DBIDMIter niter2;
        int counter = 0;
        if (!newFwd.isEmpty()) {
            DBIDMIter sniter = newFwd.iter();
            while (sniter.valid()) {
                niter2 = newFwd.iter();
                while (niter2.valid()) {
                    if (DBIDUtil.compare(sniter, niter2) < 0) {
                        this.addpair(flag, sniter, niter2);
                        ++counter;
                    }
                    niter2.advance();
                }
                niter2 = oldFwd.iter();
                while (niter2.valid()) {
                    if (!DBIDUtil.equal(sniter, niter2)) {
                        this.addpair(flag, sniter, niter2);
                        ++counter;
                    }
                    niter2.advance();
                }
                sniter.advance();
            }
        }
        if (!newRev.isEmpty()) {
            DBIDMIter nriter = newRev.iter();
            while (nriter.valid()) {
                niter2 = newRev.iter();
                while (niter2.valid()) {
                    if (DBIDUtil.compare(nriter, niter2) < 0) {
                        this.addpair(flag, nriter, niter2);
                        ++counter;
                    }
                    niter2.advance();
                }
                niter2 = oldRev.iter();
                while (niter2.valid()) {
                    if (!DBIDUtil.equal(nriter, niter2)) {
                        this.addpair(flag, nriter, niter2);
                        ++counter;
                    }
                    niter2.advance();
                }
                nriter.advance();
            }
        }
        if (!newFwd.isEmpty()) {
            DBIDMIter sniter2 = newFwd.iter();
            while (sniter2.valid()) {
                niter2 = oldRev.iter();
                while (niter2.valid()) {
                    if (!DBIDUtil.equal(sniter2, niter2)) {
                        this.addpair(flag, sniter2, niter2);
                        ++counter;
                    }
                    niter2.advance();
                }
                niter2 = newRev.iter();
                while (niter2.valid()) {
                    if (DBIDUtil.compare(sniter2, niter2) < 0) {
                        this.addpair(flag, sniter2, niter2);
                        ++counter;
                    }
                    niter2.advance();
                }
                sniter2.advance();
            }
        }
        if (!newRev.isEmpty() && !oldFwd.isEmpty()) {
            DBIDMIter niter = oldFwd.iter();
            while (niter.valid()) {
                niter2 = newRev.iter();
                while (niter2.valid()) {
                    if (!DBIDUtil.equal(niter, niter2)) {
                        this.addpair(flag, niter, niter2);
                        ++counter;
                    }
                    niter2.advance();
                }
                niter.advance();
            }
        }
        return counter;
    }

    private boolean add(DBIDRef cur, DBIDRef cand, double distance) {
        KNNHeap neighbors = (KNNHeap)this.store.get(cur);
        if (neighbors.contains(cand)) {
            return false;
        }
        double newKDistance = neighbors.insert(distance, cand);
        return distance <= newKDistance;
    }

    private void addpair(WritableDataStore<HashSetModifiableDBIDs> newNeighbors, DBIDRef o1, DBIDRef o2) {
        double distance = this.distanceQuery.distance(o1, o2);
        if (this.add(o1, o2, distance)) {
            ((HashSetModifiableDBIDs)newNeighbors.get(o1)).add(o2);
        }
        if (this.add(o2, o1, distance)) {
            ((HashSetModifiableDBIDs)newNeighbors.get(o2)).add(o1);
        }
    }

    private int sampleNew(DBIDs ids, WritableDataStore<HashSetModifiableDBIDs> sampleNewNeighbors, WritableDataStore<HashSetModifiableDBIDs> newNeighborHash, int items) {
        int t = 0;
        DBIDIter iditer = ids.iter();
        while (iditer.valid()) {
            KNNHeap realNeighbors = (KNNHeap)this.store.get(iditer);
            HashSetModifiableDBIDs newNeighbors = (HashSetModifiableDBIDs)newNeighborHash.get(iditer);
            HashSetModifiableDBIDs realNewNeighbors = (HashSetModifiableDBIDs)sampleNewNeighbors.get(iditer);
            realNewNeighbors.clear();
            DoubleDBIDListIter heapiter = realNeighbors.unorderedIterator();
            while (heapiter.valid()) {
                if (newNeighbors.contains(heapiter)) {
                    realNewNeighbors.add(heapiter);
                    ++t;
                }
                heapiter.advance();
            }
            this.boundSize(realNewNeighbors, items);
            newNeighbors.removeDBIDs(realNewNeighbors);
            newNeighborHash.put(iditer, newNeighbors);
            iditer.advance();
        }
        return t;
    }

    private void reverse(WritableDataStore<HashSetModifiableDBIDs> sampleNewHash, WritableDataStore<HashSetModifiableDBIDs> newReverseNeighbors, WritableDataStore<HashSetModifiableDBIDs> oldReverseNeighbors) {
        DBIDIter iditer = this.relation.iterDBIDs();
        while (iditer.valid()) {
            KNNHeap heap = (KNNHeap)this.store.get(iditer);
            HashSetDBIDs newNeighbors = (HashSetDBIDs)sampleNewHash.get(iditer);
            DoubleDBIDListIter heapiter = heap.unorderedIterator();
            while (heapiter.valid()) {
                ((HashSetModifiableDBIDs)(newNeighbors.contains(heapiter) ? newReverseNeighbors : oldReverseNeighbors).get(heapiter)).add(iditer);
                heapiter.advance();
            }
            iditer.advance();
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public void logStatistics() {
    }

    @Override
    public String getLongName() {
        return "NNDescent kNN";
    }

    @Override
    public String getShortName() {
        return "nn-descent-knn";
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        for (Object hint : hints) {
            if (!"exact".equals(hint)) continue;
            return null;
        }
        return super.getKNNQuery(distanceQuery, hints);
    }

    public static class Factory<O>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        private final RandomFactory rnd;
        private final double delta;
        private final double rho;
        private final boolean noInitialNeighbors;
        private final int iterations;

        public Factory(int k, DistanceFunction<? super O> distanceFunction, RandomFactory rnd, double delta, double rho, boolean noInitialNeighbors, int iterations) {
            super(k, distanceFunction);
            this.rnd = rnd;
            this.delta = delta;
            this.rho = rho;
            this.noInitialNeighbors = noInitialNeighbors;
            this.iterations = iterations;
        }

        @Override
        public NNDescent<O> instantiate(Relation<O> relation) {
            return new NNDescent<O>(relation, this.distanceFunction, this.k, this.rnd, this.delta, this.rho, this.noInitialNeighbors, this.iterations);
        }

        public static class Parameterizer<O>
        extends AbstractMaterializeKNNPreprocessor.Factory.Parameterizer<O> {
            public static final OptionID SEED_ID = new OptionID("knngraph.seed", "The random number seed.");
            public static final OptionID DELTA_ID = new OptionID("knngraph.delta", "The early termination parameter.");
            public static final OptionID RHO_ID = new OptionID("knngraph.rho", "The sample rate parameter");
            public static final OptionID INITIAL_ID = new OptionID("knngraph.no-initial", "Do not use initial neighbors.");
            public static final OptionID ITER_ID = new OptionID("knngraph.maxiter", "maximum number of iterations");
            private RandomFactory rnd;
            private double delta;
            private double rho;
            private boolean noInitialNeighbors;
            private int iterations;

            @Override
            protected void makeOptions(Parameterization config) {
                IntParameter iterP;
                Flag initialP;
                DoubleParameter rhoP;
                DoubleParameter deltaP;
                super.makeOptions(config);
                RandomParameter rndP = new RandomParameter(SEED_ID);
                if (config.grab(rndP)) {
                    this.rnd = (RandomFactory)rndP.getValue();
                }
                if (config.grab(deltaP = (DoubleParameter)new DoubleParameter(DELTA_ID, 0.001).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                    this.delta = (Double)deltaP.getValue();
                }
                if (config.grab(rhoP = (DoubleParameter)new DoubleParameter(RHO_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE))) {
                    this.rho = (Double)rhoP.getValue();
                }
                if (config.grab(initialP = new Flag(INITIAL_ID))) {
                    this.noInitialNeighbors = initialP.isTrue();
                }
                if (config.grab(iterP = (IntParameter)new IntParameter(ITER_ID, 100).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                    this.iterations = (Integer)iterP.getValue();
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.k, this.distanceFunction, this.rnd, this.delta, this.rho, this.noInitialNeighbors, this.iterations);
            }
        }
    }
}

