/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.random.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Fast and Scalable Outlier Detection with Approximate Nearest Neighbor Ensembles", booktitle="Proc. 20th Int. Conf. Database Systems for Advanced Applications (DASFAA 2015)", url="https://doi.org/10.1007/978-3-319-18123-3_2", bibkey="DBLP:conf/dasfaa/SchubertZK15")
public class NaiveProjectedKNNPreprocessor<O extends NumberVector>
implements KNNIndex<O> {
    protected final Relation<O> relation;
    private static final Logging LOG = Logging.getLogger(NaiveProjectedKNNPreprocessor.class);
    final double window;
    final int projections;
    WritableDataStore<int[]> positions = null;
    Mean mean = new Mean();
    RandomProjectionFamily proj;
    Random random;
    List<ModifiableDoubleDBIDList> projected;

    public NaiveProjectedKNNPreprocessor(Relation<O> relation, double window, int projections, RandomProjectionFamily proj, Random random) {
        this.relation = relation;
        this.window = window;
        this.projections = projections;
        this.proj = proj;
        this.random = random;
    }

    @Override
    public void initialize() {
        if (this.positions != null) {
            throw new UnsupportedOperationException("Preprocessor already ran.");
        }
        if (this.relation.size() > 0) {
            this.preprocess();
        }
    }

    protected void preprocess() {
        int j;
        Object v;
        DBIDIter iditer;
        long starttime = System.nanoTime();
        int size = this.relation.size();
        int idim = RelationUtil.dimensionality(this.relation);
        int odim = this.projections > 0 ? this.projections : idim;
        this.projected = new ArrayList<ModifiableDoubleDBIDList>(odim);
        for (int j2 = 0; j2 < odim; ++j2) {
            this.projected.add(DBIDUtil.newDistanceDBIDList(size));
        }
        if (this.proj == null) {
            int[] permutation = NaiveProjectedKNNPreprocessor.range(0, idim);
            if (odim < idim) {
                NaiveProjectedKNNPreprocessor.randomPermutation(permutation, this.random);
            }
            iditer = this.relation.iterDBIDs();
            while (iditer.valid()) {
                v = (NumberVector)this.relation.get(iditer);
                for (j = 0; j < odim; ++j) {
                    this.projected.get(j).add(v.doubleValue(permutation[j]), iditer);
                }
                iditer.advance();
            }
        } else {
            RandomProjectionFamily.Projection mat = this.proj.generateProjection(idim, odim);
            iditer = this.relation.iterDBIDs();
            while (iditer.valid()) {
                v = mat.project((NumberVector)this.relation.get(iditer));
                for (j = 0; j < odim; ++j) {
                    this.projected.get(j).add((double)v[j], iditer);
                }
                iditer.advance();
            }
        }
        for (int j3 = 0; j3 < odim; ++j3) {
            this.projected.get(j3).sort();
        }
        this.positions = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 3, int[].class);
        for (int cnum = 0; cnum < odim; ++cnum) {
            DoubleDBIDListMIter it = this.projected.get(cnum).iter();
            int i = 0;
            while (it.valid()) {
                int[] data;
                if (cnum == 0) {
                    data = new int[odim];
                    this.positions.put(it, data);
                } else {
                    data = (int[])this.positions.get(it);
                }
                data[cnum] = i++;
                it.advance();
            }
        }
        long end = System.nanoTime();
        if (LOG.isVerbose()) {
            LOG.verbose("SFC preprocessor took " + (double)(end - starttime) / 1000000.0 + " milliseconds.");
        }
    }

    public static int[] range(int start, int end) {
        int[] out = new int[end - start];
        int i = 0;
        int j = start;
        while (j < end) {
            out[i] = j++;
            ++i;
        }
        return out;
    }

    public static int[] randomPermutation(int[] out, Random random) {
        for (int i = out.length - 1; i > 0; --i) {
            int ri = random.nextInt(i + 1);
            int tmp = out[ri];
            out[ri] = out[i];
            out[i] = tmp;
        }
        return out;
    }

    @Override
    public String getLongName() {
        return "Space Filling Curve KNN preprocessor";
    }

    @Override
    public String getShortName() {
        return "spacefilling-knn";
    }

    @Override
    public void logStatistics() {
        LOG.statistics(new DoubleStatistic(this.getClass().getCanonicalName() + ".distance-computations-per-k", this.mean.getMean()));
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        for (Object hint : hints) {
            if (!"exact".equals(hint)) continue;
            return null;
        }
        return new NaiveProjectedKNNQuery(distanceQuery);
    }

    public static class Factory<V extends NumberVector>
    implements IndexFactory<V> {
        double window;
        int projections;
        RandomProjectionFamily proj;
        RandomFactory random;

        public Factory(double window, int projections, RandomProjectionFamily proj, RandomFactory random) {
            this.window = window;
            this.projections = projections;
            this.proj = proj;
            this.random = random;
        }

        @Override
        public NaiveProjectedKNNPreprocessor<V> instantiate(Relation<V> relation) {
            return new NaiveProjectedKNNPreprocessor<V>(relation, this.window, this.projections, this.proj, this.random.getRandom());
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            public static final OptionID WINDOW_ID = new OptionID("projections.windowmult", "Window size multiplicator.");
            public static final OptionID PROJECTIONS_ID = new OptionID("projections.projections", "Number of projections to use.");
            public static final OptionID PROJECTION_ID = new OptionID("projections.family", "Random projection family to use. The default is to use the original axes.");
            public static final OptionID RANDOM_ID = new OptionID("projections.seed", "Random generator.");
            double window;
            int projections = -1;
            RandomProjectionFamily proj;
            RandomFactory random;

            @Override
            protected void makeOptions(Parameterization config) {
                RandomParameter randomP;
                IntParameter projectionsP;
                super.makeOptions(config);
                DoubleParameter windowP = new DoubleParameter(WINDOW_ID, 10.0);
                if (config.grab(windowP)) {
                    this.window = (Double)windowP.getValue();
                }
                if (config.grab(projectionsP = (IntParameter)((IntParameter)new IntParameter(PROJECTIONS_ID).setOptional(true)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                    this.projections = (Integer)projectionsP.getValue();
                }
                ObjectParameter projP = new ObjectParameter(PROJECTION_ID, RandomProjectionFamily.class);
                projP.setOptional(true);
                if (config.grab(projP)) {
                    this.proj = (RandomProjectionFamily)projP.instantiateClass(config);
                }
                if (config.grab(randomP = new RandomParameter(RANDOM_ID))) {
                    this.random = (RandomFactory)randomP.getValue();
                }
            }

            @Override
            protected Factory<?> makeInstance() {
                return new Factory(this.window, this.projections, this.proj, this.random);
            }
        }
    }

    protected class NaiveProjectedKNNQuery
    implements KNNQuery<O> {
        DistanceQuery<O> distq;

        public NaiveProjectedKNNQuery(DistanceQuery<O> distanceQuery) {
            this.distq = distanceQuery;
        }

        @Override
        public KNNList getKNNForDBID(DBIDRef id, int k) {
            int wsize = (int)Math.ceil(NaiveProjectedKNNPreprocessor.this.window * (double)k);
            HashSetModifiableDBIDs cands = DBIDUtil.newHashSet(2 * wsize * NaiveProjectedKNNPreprocessor.this.projected.size());
            int[] posi = (int[])NaiveProjectedKNNPreprocessor.this.positions.get(id);
            for (int i = 0; i < posi.length; ++i) {
                DoubleDBIDListMIter it = NaiveProjectedKNNPreprocessor.this.projected.get(i).iter();
                it.seek(Math.max(0, posi[i] - wsize));
                for (int j = wsize << 1; j >= 0 && it.valid(); --j) {
                    cands.add(it);
                    it.advance();
                }
            }
            int distc = 0;
            KNNHeap heap = DBIDUtil.newHeap(k);
            NumberVector vec = (NumberVector)NaiveProjectedKNNPreprocessor.this.relation.get(id);
            DBIDMIter iter = cands.iter();
            while (iter.valid()) {
                heap.insert(this.distq.distance((DBIDMIter)((Object)vec), iter), iter);
                ++distc;
                iter.advance();
            }
            NaiveProjectedKNNPreprocessor.this.mean.put((double)distc / (double)k);
            return heap.toKNNList();
        }

        @Override
        public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs ids, int k) {
            throw new AbortException("Not yet implemented");
        }

        @Override
        public KNNList getKNNForObject(O obj, int k) {
            throw new AbortException("Not yet implemented");
        }
    }
}

