/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;

@Title(value="Partitioning Approximate kNN Preprocessor")
@Description(value="Caterializes the (approximate) k nearest neighbors of objects of a database by partitioning and only computing kNN within each partition.")
public class PartitionApproximationMaterializeKNNPreprocessor<O>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(PartitionApproximationMaterializeKNNPreprocessor.class);
    private final int partitions;
    private final RandomFactory rnd;

    public PartitionApproximationMaterializeKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int k, int partitions, RandomFactory rnd) {
        super(relation, distanceFunction, k);
        this.partitions = partitions;
        this.rnd = rnd;
    }

    @Override
    protected void preprocess() {
        DistanceQuery distanceQuery = this.relation.getDistanceQuery(this.distanceFunction, new Object[0]);
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 4, KNNList.class);
        MeanVariance ksize = new MeanVariance();
        if (LOG.isVerbose()) {
            LOG.verbose("Approximating nearest neighbor lists to database objects");
        }
        ArrayDBIDs[] parts = DBIDUtil.randomSplit(this.relation.getDBIDs(), this.partitions, this.rnd);
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Processing partitions", this.partitions, LOG) : null;
        for (int part = 0; part < this.partitions; ++part) {
            ArrayDBIDs ids = parts[part];
            int size = ids.size();
            Object2DoubleOpenHashMap<DBIDPair> cache = new Object2DoubleOpenHashMap<DBIDPair>(size * size * 3 >> 3);
            cache.defaultReturnValue(Double.NaN);
            DBIDArrayIter iter = ids.iter();
            while (iter.valid()) {
                KNNHeap kNN = DBIDUtil.newHeap(this.k);
                DBIDArrayIter iter2 = ids.iter();
                while (iter2.valid()) {
                    DBIDPair key = DBIDUtil.newPair(iter, (DBIDRef)iter2);
                    double d = cache.removeDouble(key);
                    if (d == d) {
                        kNN.insert(d, iter2);
                    } else {
                        d = distanceQuery.distance((DBIDRef)iter, (DBIDRef)iter2);
                        kNN.insert(d, iter2);
                        key = DBIDUtil.newPair(iter2, (DBIDRef)iter);
                        cache.put(key, d);
                    }
                    iter2.advance();
                }
                ksize.put(kNN.size());
                this.storage.put(iter, kNN.toKNNList());
                iter.advance();
            }
            if (LOG.isDebugging() && cache.size() > 0) {
                LOG.warning("Cache should be empty after each run, but still has " + cache.size() + " elements.");
            }
            LOG.incrementProcessed(progress);
        }
        LOG.ensureCompleted(progress);
        if (LOG.isVerbose()) {
            LOG.verbose("On average, " + ksize.getMean() + " +- " + ksize.getSampleStddev() + " neighbors returned.");
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "Random partition kNN approximation";
    }

    @Override
    public String getShortName() {
        return "random-partition-knn";
    }

    @Override
    public void logStatistics() {
    }

    public static class Factory<O>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        int partitions;
        private final RandomFactory rnd;

        public Factory(int k, DistanceFunction<? super O> distanceFunction, int partitions, RandomFactory rnd) {
            super(k, distanceFunction);
            this.partitions = partitions;
            this.rnd = rnd;
        }

        @Override
        public PartitionApproximationMaterializeKNNPreprocessor<O> instantiate(Relation<O> relation) {
            PartitionApproximationMaterializeKNNPreprocessor<O> instance = new PartitionApproximationMaterializeKNNPreprocessor<O>(relation, this.distanceFunction, this.k, this.partitions, this.rnd);
            return instance;
        }

        public static class Parameterizer<O>
        extends AbstractMaterializeKNNPreprocessor.Factory.Parameterizer<O> {
            public static final OptionID PARTITIONS_ID = new OptionID("partknn.p", "The number of partitions to use for approximate kNN.");
            public static final OptionID SEED_ID = new OptionID("partknn.seed", "The random number generator seed.");
            protected int partitions = 0;
            private RandomFactory rnd;

            @Override
            protected void makeOptions(Parameterization config) {
                RandomParameter rndP;
                super.makeOptions(config);
                IntParameter partitionsP = (IntParameter)new IntParameter(PARTITIONS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
                if (config.grab(partitionsP)) {
                    this.partitions = (Integer)partitionsP.getValue();
                }
                if (config.grab(rndP = new RandomParameter(SEED_ID))) {
                    this.rnd = (RandomFactory)rndP.getValue();
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.k, this.distanceFunction, this.partitions, this.rnd);
            }
        }
    }
}

