/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;

@Reference(authors="Arthur Zimek, Matthew Gaudet, Ricardo J. G. B. Campello, J\u00f6rg Sander", title="Subsampling for Efficient and Effective Unsupervised Outlier Detection Ensembles", booktitle="Proc. 19th ACM SIGKDD Int. Conf. Knowledge Discovery and Data Mining, KDD '13", url="https://doi.org/10.1145/2487575.2487676", bibkey="DBLP:conf/kdd/ZimekGCS13")
public class RandomSampleKNNPreprocessor<O>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(RandomSampleKNNPreprocessor.class);
    private final double share;
    private final RandomFactory rnd;

    public RandomSampleKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int k, double share, RandomFactory rnd) {
        super(relation, distanceFunction, k);
        this.share = share;
        this.rnd = rnd;
    }

    @Override
    protected void preprocess() {
        DistanceQuery distanceQuery = this.relation.getDistanceQuery(this.distanceFunction, new Object[0]);
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 4, KNNList.class);
        FiniteProgress progress = this.getLogger().isVerbose() ? new FiniteProgress("Materializing random-sample k nearest neighbors (k=" + this.k + ")", this.relation.size(), this.getLogger()) : null;
        ArrayDBIDs ids = DBIDUtil.ensureArray(this.relation.getDBIDs());
        int samplesize = (int)((double)ids.size() * this.share);
        Random random = this.rnd.getSingleThreadedRandom();
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            KNNHeap kNN = DBIDUtil.newHeap(this.k);
            ModifiableDBIDs rsamp = DBIDUtil.randomSample((DBIDs)ids, samplesize, random);
            DBIDIter iter2 = rsamp.iter();
            while (iter2.valid()) {
                double dist = distanceQuery.distance((DBIDRef)iter, (DBIDRef)iter2);
                kNN.insert(dist, iter2);
                iter2.advance();
            }
            this.storage.put(iter, kNN.toKNNList());
            this.getLogger().incrementProcessed(progress);
            iter.advance();
        }
        this.getLogger().ensureCompleted(progress);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "random sample kNN";
    }

    @Override
    public String getShortName() {
        return "random-sample-knn";
    }

    @Override
    public void logStatistics() {
    }

    public static class Factory<O>
    extends AbstractMaterializeKNNPreprocessor.Factory<O> {
        private final double share;
        private final RandomFactory rnd;

        public Factory(int k, DistanceFunction<? super O> distanceFunction, double share, RandomFactory rnd) {
            super(k, distanceFunction);
            this.share = share;
            this.rnd = rnd;
        }

        @Override
        public RandomSampleKNNPreprocessor<O> instantiate(Relation<O> relation) {
            return new RandomSampleKNNPreprocessor<O>(relation, this.distanceFunction, this.k, this.share, this.rnd);
        }

        public static class Parameterizer<O>
        extends AbstractMaterializeKNNPreprocessor.Factory.Parameterizer<O> {
            public static final OptionID SHARE_ID = new OptionID("randomknn.share", "The relative amount of objects to consider for kNN computations.");
            public static final OptionID SEED_ID = new OptionID("randomknn.seed", "The random number seed.");
            private double share = 0.0;
            private RandomFactory rnd;

            @Override
            protected void makeOptions(Parameterization config) {
                RandomParameter rndP;
                super.makeOptions(config);
                DoubleParameter shareP = (DoubleParameter)((DoubleParameter)new DoubleParameter(SHARE_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE);
                if (config.grab(shareP)) {
                    this.share = (Double)shareP.getValue();
                }
                if (config.grab(rndP = new RandomParameter(SEED_ID))) {
                    this.rnd = (RandomFactory)rndP.getValue();
                }
            }

            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.k, this.distanceFunction, this.share, this.rnd);
            }
        }
    }
}

