/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.projection.random.RandomProjectionFamily;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.SpatialPair;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.SpatialSorter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Fast and Scalable Outlier Detection with Approximate Nearest Neighbor Ensembles", booktitle="Proc. 20th Int. Conf. Database Systems for Advanced Applications (DASFAA 2015)", url="https://doi.org/10.1007/978-3-319-18123-3_2", bibkey="DBLP:conf/dasfaa/SchubertZK15")
public class SpacefillingKNNPreprocessor<O extends NumberVector>
implements KNNIndex<O> {
    private static final Logging LOG = Logging.getLogger(SpacefillingKNNPreprocessor.class);
    protected final Relation<O> relation;
    final List<SpatialSorter> curvegen;
    final double window;
    final int variants;
    List<List<SpatialPair<DBID, NumberVector>>> curves = null;
    WritableDataStore<int[]> positions = null;
    Mean mean = new Mean();
    final int odim;
    RandomProjectionFamily proj;
    Random random;

    public SpacefillingKNNPreprocessor(Relation<O> relation, List<SpatialSorter> curvegen, double window, int variants, int odim, RandomProjectionFamily proj, Random random) {
        this.relation = relation;
        this.curvegen = curvegen;
        this.window = window;
        this.variants = variants;
        this.odim = odim;
        this.proj = proj;
        this.random = random;
    }

    @Override
    public void initialize() {
        if (this.curves != null) {
            throw new UnsupportedOperationException("Preprocessor already ran.");
        }
        if (this.relation.size() > 0) {
            this.preprocess();
        }
    }

    protected void preprocess() {
        long starttime = System.currentTimeMillis();
        int size = this.relation.size();
        int numgen = this.curvegen.size();
        int numcurves = this.variants;
        this.curves = new ArrayList<List<SpatialPair<DBID, NumberVector>>>(numcurves);
        for (int i = 0; i < numcurves; ++i) {
            this.curves.add(new ArrayList(size));
        }
        if (this.proj == null) {
            DBIDIter iditer = this.relation.iterDBIDs();
            while (iditer.valid()) {
                NumberVector v = (NumberVector)this.relation.get(iditer);
                SpatialPair<DBID, NumberVector> ref = new SpatialPair<DBID, NumberVector>(DBIDUtil.deref(iditer), v);
                for (List<SpatialPair<DBID, NumberVector>> curve : this.curves) {
                    curve.add(ref);
                }
                iditer.advance();
            }
            double[] mms = SpatialSorter.computeMinMax((Iterable<? extends SpatialComparable>)this.curves.get(0));
            double extend = 0.0;
            int e = mms.length - 1;
            for (int d2 = 0; d2 < e; d2 += 2) {
                extend = Math.max(extend, mms[d2 + 1] - mms[d2]);
            }
            double[] mmscratch = new double[mms.length];
            int idim = mms.length >>> 1;
            int dim = this.odim < 0 ? idim : Math.min(this.odim, idim);
            int[] permutation = SpacefillingKNNPreprocessor.range(0, idim);
            int[] apermutation = dim != idim ? new int[dim] : permutation;
            for (int j = 0; j < numcurves; ++j) {
                int ctype = numgen > 1 ? this.random.nextInt(numgen) : 0;
                double scale = 1.0 + this.random.nextDouble();
                int e2 = mms.length - 1;
                for (int d2 = 0; d2 < e2; d2 += 2) {
                    mmscratch[d2] = mms[d2] - extend * this.random.nextDouble();
                    mmscratch[d2 + 1] = mmscratch[d2] + extend * scale;
                }
                SpacefillingKNNPreprocessor.randomPermutation(permutation, this.random);
                System.arraycopy(permutation, 0, apermutation, 0, dim);
                this.curvegen.get(ctype).sort(this.curves.get(j), 0, size, mmscratch, apermutation);
            }
        } else {
            int idim = RelationUtil.dimensionality(this.relation);
            int dim = this.odim < 0 ? idim : this.odim;
            int[] permutation = SpacefillingKNNPreprocessor.range(0, dim);
            NumberVector.Factory<O> factory = RelationUtil.getNumberVectorFactory(this.relation);
            double[] mms = new double[this.odim << 1];
            for (int j = 0; j < numcurves; ++j) {
                int d2;
                List<SpatialPair<DBID, NumberVector>> curve = this.curves.get(j);
                RandomProjectionFamily.Projection mat = this.proj.generateProjection(idim, dim);
                int ctype = numgen > 1 ? this.random.nextInt(numgen) : 0;
                for (int d22 = 0; d22 < mms.length; d22 += 2) {
                    mms[d22] = Double.POSITIVE_INFINITY;
                    mms[d22 + 1] = Double.NEGATIVE_INFINITY;
                }
                DBIDIter iditer = this.relation.iterDBIDs();
                while (iditer.valid()) {
                    double[] proj = mat.project((NumberVector)this.relation.get(iditer));
                    curve.add(new SpatialPair<DBID, O>(DBIDUtil.deref(iditer), factory.newNumberVector(proj)));
                    d2 = 0;
                    int d = 0;
                    while (d2 < mms.length) {
                        mms[d2] = Math.min(mms[d2], proj[d]);
                        mms[d2 + 1] = Math.max(mms[d2 + 1], proj[d]);
                        d2 += 2;
                        ++d;
                    }
                    iditer.advance();
                }
                double extend = 0.0;
                for (d2 = 0; d2 < mms.length; d2 += 2) {
                    extend = Math.max(extend, mms[d2 + 1] - mms[d2]);
                }
                double scale = 1.0 + this.random.nextDouble();
                for (int d23 = 0; d23 < mms.length; d23 += 2) {
                    int n = d23;
                    mms[n] = mms[n] - extend * this.random.nextDouble();
                    mms[d23 + 1] = mms[d23] + extend * scale;
                }
                SpacefillingKNNPreprocessor.randomPermutation(permutation, this.random);
                this.curvegen.get(ctype).sort(curve, 0, size, mms, permutation);
            }
        }
        this.positions = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 3, int[].class);
        for (int cnum = 0; cnum < numcurves; ++cnum) {
            Iterator<SpatialPair<DBID, NumberVector>> it = this.curves.get(cnum).iterator();
            int i = 0;
            while (it.hasNext()) {
                int[] data;
                SpatialPair<DBID, NumberVector> r = it.next();
                if (cnum == 0) {
                    data = new int[numcurves];
                    this.positions.put((DBIDRef)r.first, data);
                } else {
                    data = (int[])this.positions.get((DBIDRef)r.first);
                }
                data[cnum] = i++;
            }
        }
        long end = System.currentTimeMillis();
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(this.getClass().getCanonicalName() + ".construction-time.ms", end - starttime));
        }
    }

    public static int[] range(int start, int end) {
        int[] out = new int[end - start];
        int i = 0;
        int j = start;
        while (j < end) {
            out[i] = j++;
            ++i;
        }
        return out;
    }

    public static int[] randomPermutation(int[] out, Random random) {
        for (int i = out.length - 1; i > 0; --i) {
            int ri = random.nextInt(i + 1);
            int tmp = out[ri];
            out[ri] = out[i];
            out[i] = tmp;
        }
        return out;
    }

    @Override
    public String getLongName() {
        return "Space Filling Curve KNN preprocessor";
    }

    @Override
    public String getShortName() {
        return "spacefilling-knn";
    }

    @Override
    public void logStatistics() {
        LOG.statistics(new DoubleStatistic(this.getClass().getCanonicalName() + ".distance-computations-per-k", this.mean.getMean()));
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        for (Object hint : hints) {
            if (!"exact".equals(hint)) continue;
            return null;
        }
        return new SpaceFillingKNNQuery(distanceQuery);
    }

    public static class Factory<V extends NumberVector>
    implements IndexFactory<V> {
        List<SpatialSorter> curvegen;
        double window;
        int variants;
        int odim;
        RandomProjectionFamily proj;
        RandomFactory random;

        public Factory(List<SpatialSorter> curvegen, double window, int variants, int odim, RandomProjectionFamily proj, RandomFactory random) {
            this.curvegen = curvegen;
            this.window = window;
            this.variants = variants;
            this.odim = odim;
            this.proj = proj;
            this.random = random;
        }

        @Override
        public SpacefillingKNNPreprocessor<V> instantiate(Relation<V> relation) {
            return new SpacefillingKNNPreprocessor<V>(relation, this.curvegen, this.window, this.variants, this.odim, this.proj, this.random.getRandom());
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            public static final OptionID CURVES_ID = new OptionID("sfcknn.curves", "Space filling curve generators to use for kNN approximation.");
            public static final OptionID WINDOW_ID = new OptionID("sfcknn.windowmult", "Window size multiplicator.");
            public static final OptionID VARIANTS_ID = new OptionID("sfcknn.variants", "Number of curve variants to generate.");
            public static final OptionID DIM_ID = new OptionID("sfcknn.dim", "Number of dimensions to use for each curve.");
            public static final OptionID PROJECTION_ID = new OptionID("sfcknn.proj", "Random projection to use.");
            public static final OptionID RANDOM_ID = new OptionID("sfcknn.seed", "Random generator.");
            List<SpatialSorter> curvegen;
            double window;
            int variants;
            int odim = -1;
            RandomProjectionFamily proj;
            RandomFactory random;

            @Override
            protected void makeOptions(Parameterization config) {
                RandomParameter randomP;
                IntParameter dimP;
                IntParameter variantsP;
                DoubleParameter windowP;
                super.makeOptions(config);
                ObjectListParameter curveP = new ObjectListParameter(CURVES_ID, SpatialSorter.class);
                if (config.grab(curveP)) {
                    this.curvegen = curveP.instantiateClasses(config);
                }
                if (config.grab(windowP = new DoubleParameter(WINDOW_ID, 10.0))) {
                    this.window = (Double)windowP.getValue();
                }
                if (config.grab(variantsP = (IntParameter)new IntParameter(VARIANTS_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                    this.variants = (Integer)variantsP.getValue();
                }
                if (config.grab(dimP = (IntParameter)((IntParameter)new IntParameter(DIM_ID).setOptional(true)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                    this.odim = dimP.intValue();
                }
                ObjectParameter projP = new ObjectParameter(PROJECTION_ID, RandomProjectionFamily.class);
                projP.setOptional(true);
                if (config.grab(projP)) {
                    this.proj = (RandomProjectionFamily)projP.instantiateClass(config);
                }
                if (config.grab(randomP = new RandomParameter(RANDOM_ID))) {
                    this.random = (RandomFactory)randomP.getValue();
                }
            }

            @Override
            protected Factory<?> makeInstance() {
                return new Factory(this.curvegen, this.window, this.variants, this.odim, this.proj, this.random);
            }
        }
    }

    protected class SpaceFillingKNNQuery
    implements KNNQuery<O> {
        DistanceQuery<O> distq;

        public SpaceFillingKNNQuery(DistanceQuery<O> distanceQuery) {
            this.distq = distanceQuery;
        }

        @Override
        public KNNList getKNNForDBID(DBIDRef id, int k) {
            int wsize = (int)Math.ceil(SpacefillingKNNPreprocessor.this.window * (double)k);
            HashSetModifiableDBIDs cands = DBIDUtil.newHashSet(2 * wsize * SpacefillingKNNPreprocessor.this.curves.size());
            int[] posi = (int[])SpacefillingKNNPreprocessor.this.positions.get(id);
            for (int i = 0; i < posi.length; ++i) {
                List<SpatialPair<DBID, NumberVector>> curve = SpacefillingKNNPreprocessor.this.curves.get(i);
                int start = Math.max(0, posi[i] - wsize);
                int end = Math.min(posi[i] + wsize + 1, curve.size());
                for (int j = start; j < end; ++j) {
                    cands.add((DBIDRef)curve.get((int)j).first);
                }
            }
            int distc = 0;
            KNNHeap heap = DBIDUtil.newHeap(k);
            NumberVector vec = (NumberVector)SpacefillingKNNPreprocessor.this.relation.get(id);
            DBIDMIter iter = cands.iter();
            while (iter.valid()) {
                heap.insert(this.distq.distance((DBIDMIter)((Object)vec), iter), iter);
                ++distc;
                iter.advance();
            }
            SpacefillingKNNPreprocessor.this.mean.put((double)distc / (double)k);
            return heap.toKNNList();
        }

        @Override
        public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs ids, int k) {
            throw new AbortException("Not yet implemented");
        }

        @Override
        public KNNList getKNNForObject(O obj, int k) {
            throw new AbortException("Not yet implemented");
        }
    }
}

