/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.SpatialPair;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.SpatialSorter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Fast and Scalable Outlier Detection with Approximate Nearest Neighbor Ensembles", booktitle="Proc. 20th Int. Conf. Database Systems for Advanced Applications (DASFAA 2015)", url="https://doi.org/10.1007/978-3-319-18123-3_2", bibkey="DBLP:conf/dasfaa/SchubertZK15")
public class SpacefillingMaterializeKNNPreprocessor<O extends NumberVector>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(SpacefillingMaterializeKNNPreprocessor.class);
    final List<SpatialSorter> curvegen;
    final double window;
    final int variants;
    Mean mean = new Mean();
    Random random;

    public SpacefillingMaterializeKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int k, List<SpatialSorter> curvegen, double window, int variants, Random random) {
        super(relation, distanceFunction, k);
        this.curvegen = curvegen;
        this.window = window;
        this.variants = variants;
        this.random = random;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void preprocess() {
        void var11_14;
        long starttime = System.currentTimeMillis();
        int size = this.relation.size();
        int numgen = this.curvegen.size();
        int numcurves = numgen * this.variants;
        ArrayList curves = new ArrayList(numcurves);
        for (int i = 0; i < numcurves; ++i) {
            curves.add(new ArrayList(size));
        }
        DBIDIter iditer = this.relation.iterDBIDs();
        while (iditer.valid()) {
            NumberVector v = (NumberVector)this.relation.get(iditer);
            SpatialPair<DBID, NumberVector> ref = new SpatialPair<DBID, NumberVector>(DBIDUtil.deref(iditer), v);
            for (List list : curves) {
                list.add(ref);
            }
            iditer.advance();
        }
        double[] mms = SpatialSorter.computeMinMax((Iterable)curves.get(0));
        double[] mmscratch = new double[mms.length];
        int numdim = mms.length >>> 1;
        int[] permutation = new int[numdim];
        boolean bl = false;
        while (var11_14 < this.variants) {
            int i;
            int e = mms.length - 1;
            for (i = 0; i < e; i += 2) {
                double len = mms[i + 1] - mms[i];
                mmscratch[i] = mms[i] - len * this.random.nextDouble();
                mmscratch[i + 1] = mms[i + 1] + len * this.random.nextDouble();
            }
            for (i = 0; i < numdim; ++i) {
                permutation[i] = i;
            }
            for (i = numdim - 1; i > 0; --i) {
                int ri = this.random.nextInt(i + 1);
                int tmp = permutation[ri];
                permutation[ri] = permutation[i];
                permutation[i] = tmp;
            }
            for (i = 0; i < numgen; ++i) {
                this.curvegen.get(i).sort((List)curves.get(i + numgen * var11_14), 0, size, mmscratch, permutation);
            }
            ++var11_14;
        }
        WritableDataStore<int[]> writableDataStore = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 3, int[].class);
        for (int cnum = 0; cnum < numcurves; ++cnum) {
            Iterator it = ((List)curves.get(cnum)).iterator();
            int i = 0;
            while (it.hasNext()) {
                int[] data;
                SpatialPair r = (SpatialPair)it.next();
                if (cnum == 0) {
                    data = new int[numcurves];
                    writableDataStore.put((DBIDRef)r.first, data);
                } else {
                    data = (int[])writableDataStore.get((DBIDRef)r.first);
                }
                data[cnum] = i++;
            }
        }
        int wsize = (int)Math.ceil(this.window * (double)this.k);
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 4, KNNList.class);
        HashSetModifiableDBIDs cands = DBIDUtil.newHashSet(2 * wsize * numcurves);
        DBIDIter iditer2 = this.relation.iterDBIDs();
        while (iditer2.valid()) {
            cands.clear();
            int[] posi = (int[])writableDataStore.get(iditer2);
            for (int i = 0; i < posi.length; ++i) {
                List curve = (List)curves.get(i);
                int start = Math.max(0, posi[i] - wsize);
                int end = Math.min(posi[i] + wsize + 1, curve.size());
                for (int pos = start; pos < end; ++pos) {
                    cands.add((DBIDRef)((SpatialPair)curve.get((int)pos)).first);
                }
            }
            int distc = 0;
            KNNHeap heap = DBIDUtil.newHeap(this.k);
            NumberVector vec = (NumberVector)this.relation.get(iditer2);
            DBIDMIter iter = cands.iter();
            while (iter.valid()) {
                heap.insert(this.distanceQuery.distance(vec, iter), iter);
                ++distc;
                iter.advance();
            }
            this.storage.put(iditer2, heap.toKNNList());
            this.mean.put((double)distc / (double)this.k);
            iditer2.advance();
        }
        long end = System.currentTimeMillis();
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(this.getClass().getCanonicalName() + ".construction-time.ms", end - starttime));
        }
    }

    @Override
    public String getLongName() {
        return "Space Filling Curve KNN preprocessor";
    }

    @Override
    public String getShortName() {
        return "spacefilling-knn";
    }

    @Override
    public void logStatistics() {
        LOG.statistics(new DoubleStatistic(this.getClass().getCanonicalName() + ".distance-computations-per-k", this.mean.getMean()));
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distQ, Object ... hints) {
        for (Object hint : hints) {
            if (!"exact".equals(hint)) continue;
            return null;
        }
        return super.getKNNQuery(distQ, hints);
    }

    public static class Factory<V extends NumberVector>
    extends AbstractMaterializeKNNPreprocessor.Factory<V> {
        List<SpatialSorter> curvegen;
        double window;
        int variants;
        RandomFactory random;

        public Factory(int k, DistanceFunction<? super V> distanceFunction, List<SpatialSorter> curvegen, double window, int variants, RandomFactory random) {
            super(k, distanceFunction);
            this.curvegen = curvegen;
            this.window = window;
            this.variants = variants;
            this.random = random;
        }

        @Override
        public SpacefillingMaterializeKNNPreprocessor<V> instantiate(Relation<V> relation) {
            return new SpacefillingMaterializeKNNPreprocessor<V>(relation, this.distanceFunction, this.k, this.curvegen, this.window, this.variants, this.random.getRandom());
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Parameterizer<V extends NumberVector>
        extends AbstractMaterializeKNNPreprocessor.Factory.Parameterizer<V> {
            public static final OptionID CURVES_ID = new OptionID("sfcknn.curves", "Space filling curve generators to use for kNN approximation.");
            public static final OptionID WINDOW_ID = new OptionID("sfcknn.windowmult", "Window size multiplicator.");
            public static final OptionID VARIANTS_ID = new OptionID("sfcknn.variants", "Number of curve variants to generate.");
            public static final OptionID RANDOM_ID = new OptionID("sfcknn.seed", "Random generator.");
            List<SpatialSorter> curvegen;
            double window;
            int variants;
            RandomFactory random;

            @Override
            protected void makeOptions(Parameterization config) {
                RandomParameter randomP;
                IntParameter variantsP;
                DoubleParameter windowP;
                super.makeOptions(config);
                ObjectListParameter curveP = new ObjectListParameter(CURVES_ID, SpatialSorter.class);
                if (config.grab(curveP)) {
                    this.curvegen = curveP.instantiateClasses(config);
                }
                if (config.grab(windowP = new DoubleParameter(WINDOW_ID, 10.0))) {
                    this.window = (Double)windowP.getValue();
                }
                if (config.grab(variantsP = (IntParameter)new IntParameter(VARIANTS_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                    this.variants = (Integer)variantsP.getValue();
                }
                if (config.grab(randomP = new RandomParameter(RANDOM_ID))) {
                    this.random = (RandomFactory)randomP.getValue();
                }
            }

            @Override
            protected Factory<V> makeInstance() {
                return new Factory(this.k, this.distanceFunction, this.curvegen, this.window, this.variants, this.random);
            }
        }
    }
}

