/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.index.tree.LeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialIndexTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialNode;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.List;

@Title(value="Spatial Approximation Materialize kNN Preprocessor")
@Description(value="Caterializes the (approximate) k nearest neighbors of objects of a database using a spatial approximation.")
@Alias(value={"de.lmu.ifi.dbs.elki.preprocessing.SpatialApproximationMaterializeKNNPreprocessor"})
public class SpatialApproximationMaterializeKNNPreprocessor<O extends NumberVector, N extends SpatialNode<N, E>, E extends SpatialEntry>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(SpatialApproximationMaterializeKNNPreprocessor.class);

    public SpatialApproximationMaterializeKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int k) {
        super(relation, distanceFunction, k);
    }

    @Override
    protected void preprocess() {
        DistanceQuery distanceQuery = this.relation.getDistanceQuery(this.distanceFunction, new Object[0]);
        SpatialIndexTree<N, SpatialEntry> index = this.getSpatialIndex(this.relation);
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 4, KNNList.class);
        MeanVariance pagesize = new MeanVariance();
        MeanVariance ksize = new MeanVariance();
        Logging log = this.getLogger();
        if (log.isVerbose()) {
            log.verbose("Approximating nearest neighbor lists to database objects");
        }
        List<E> leaves = index.getLeaves();
        FiniteProgress progress = log.isVerbose() ? new FiniteProgress("Processing leaf nodes", leaves.size(), log) : null;
        for (SpatialEntry leaf : leaves) {
            SpatialNode node = (SpatialNode)index.getNode(leaf);
            int size = node.getNumEntries();
            pagesize.put(size);
            if (log.isDebuggingFinest()) {
                log.debugFinest("NumEntires = " + size);
            }
            ArrayModifiableDBIDs ids = DBIDUtil.newArray(size);
            for (int i = 0; i < size; ++i) {
                ids.add(((LeafEntry)node.getEntry(i)).getDBID());
            }
            Object2DoubleOpenHashMap<DBIDPair> cache = new Object2DoubleOpenHashMap<DBIDPair>(size * size * 3 >> 3);
            DBIDArrayMIter id = ids.iter();
            while (id.valid()) {
                KNNHeap kNN = DBIDUtil.newHeap(this.k);
                DBIDArrayMIter id2 = ids.iter();
                while (id2.valid()) {
                    DBIDPair key = DBIDUtil.newPair(id, (DBIDRef)id2);
                    double d = cache.removeDouble(key);
                    if (d == d) {
                        kNN.insert(d, id2);
                    } else {
                        d = distanceQuery.distance((DBIDRef)id, (DBIDRef)id2);
                        kNN.insert(d, id2);
                        key = DBIDUtil.newPair(id2, (DBIDRef)id);
                        cache.put(key, d);
                    }
                    id2.advance();
                }
                ksize.put(kNN.size());
                this.storage.put(id, kNN.toKNNList());
                id.advance();
            }
            if (log.isDebugging() && cache.size() > 0) {
                log.warning("Cache should be empty after each run, but still has " + cache.size() + " elements.");
            }
            log.incrementProcessed(progress);
        }
        log.ensureCompleted(progress);
        if (log.isVerbose()) {
            log.verbose("Average page size = " + pagesize.getMean() + " +- " + pagesize.getSampleStddev());
            log.verbose("On average, " + ksize.getMean() + " +- " + ksize.getSampleStddev() + " neighbors returned.");
        }
    }

    protected SpatialIndexTree<N, E> getSpatialIndex(Relation<O> relation) {
        SpatialIndexTree ret = null;
        It<SpatialIndexTree> iter = relation.getHierarchy().iterDescendants(relation).filter(SpatialIndexTree.class);
        while (iter.valid()) {
            if (ret != null) {
                throw new IllegalStateException("More than one spatial index found - this is not supported!");
            }
            ret = iter.get();
            iter.advance();
        }
        if (ret == null) {
            throw new IllegalStateException("No spatial index found!");
        }
        return ret;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public String getLongName() {
        return "Spatial Index Approximative kNN";
    }

    @Override
    public String getShortName() {
        return "spatial-approximate-knn";
    }

    @Override
    public void logStatistics() {
    }

    public static class Factory<N extends SpatialNode<N, E>, E extends SpatialEntry>
    extends AbstractMaterializeKNNPreprocessor.Factory<NumberVector> {
        public Factory(int k, DistanceFunction<? super NumberVector> distanceFunction) {
            super(k, distanceFunction);
        }

        public SpatialApproximationMaterializeKNNPreprocessor<NumberVector, N, E> instantiate(Relation<NumberVector> relation) {
            SpatialApproximationMaterializeKNNPreprocessor instance = new SpatialApproximationMaterializeKNNPreprocessor(relation, this.distanceFunction, this.k);
            return instance;
        }

        public static class Parameterizer<N extends SpatialNode<N, E>, E extends SpatialEntry>
        extends AbstractMaterializeKNNPreprocessor.Factory.Parameterizer<NumberVector> {
            @Override
            protected Factory<N, E> makeInstance() {
                return new Factory(this.k, (DistanceFunction<? super NumberVector>)((DistanceFunction<NumberVector>)((DistanceFunction<? super NumberVector>)this.distanceFunction)));
            }
        }
    }
}

