/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.localpca;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.AbstractPreprocessorIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.localpca.FilteredLocalPCAIndex;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.PercentageEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.EmptyDataException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="Local PCA Preprocessor")
@Description(value="Materializes the local PCA and the locally weighted matrix of objects of a database.")
public abstract class AbstractFilteredPCAIndex<NV extends NumberVector>
extends AbstractPreprocessorIndex<NV, PCAFilteredResult>
implements FilteredLocalPCAIndex<NV> {
    protected final PCARunner pca;
    protected EigenPairFilter filter;

    public AbstractFilteredPCAIndex(Relation<NV> relation, PCARunner pca, EigenPairFilter filter) {
        super(relation);
        this.pca = pca;
        this.filter = filter;
    }

    @Override
    public void initialize() {
        if (this.relation == null || this.relation.size() <= 0) {
            throw new EmptyDataException();
        }
        if (this.storage != null) {
            return;
        }
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 3, PCAFilteredResult.class);
        long start = System.currentTimeMillis();
        FiniteProgress progress = this.getLogger().isVerbose() ? new FiniteProgress("Performing local PCA", this.relation.size(), this.getLogger()) : null;
        DBIDIter iditer = this.relation.iterDBIDs();
        while (iditer.valid()) {
            PCAResult epairs = this.pca.processIds(this.objectsForPCA(iditer), this.relation);
            int numstrong = this.filter.filter(epairs.getEigenvalues());
            PCAFilteredResult pcares = new PCAFilteredResult(epairs.getEigenPairs(), numstrong, 1.0, 0.0);
            this.storage.put(iditer, pcares);
            this.getLogger().incrementProcessed(progress);
            iditer.advance();
        }
        this.getLogger().ensureCompleted(progress);
        if (this.getLogger().isVerbose()) {
            long elapsedTime = System.currentTimeMillis() - start;
            this.getLogger().verbose(this.getClass().getName() + " runtime: " + elapsedTime + " milliseconds.");
        }
    }

    @Override
    public PCAFilteredResult getLocalProjection(DBIDRef objid) {
        if (this.storage == null) {
            this.initialize();
        }
        return (PCAFilteredResult)this.storage.get(objid);
    }

    protected abstract DoubleDBIDList objectsForPCA(DBIDRef var1);

    public static abstract class Factory<NV extends NumberVector>
    implements FilteredLocalPCAIndex.Factory<NV> {
        protected DistanceFunction<NV> pcaDistanceFunction;
        protected PCARunner pca;
        protected EigenPairFilter filter;

        public Factory(DistanceFunction<NV> pcaDistanceFunction, PCARunner pca, EigenPairFilter filter) {
            this.pcaDistanceFunction = pcaDistanceFunction;
            this.pca = pca;
            this.filter = filter;
        }

        @Override
        public abstract AbstractFilteredPCAIndex<NV> instantiate(Relation<NV> var1);

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.pcaDistanceFunction.getInputTypeRestriction();
        }

        public static abstract class Parameterizer<NV extends NumberVector, I extends AbstractFilteredPCAIndex<NV>>
        extends AbstractParameterizer {
            public static final OptionID PCA_DISTANCE_ID = new OptionID("localpca.distancefunction", "The distance function used to select objects for running PCA.");
            protected DistanceFunction<NV> pcaDistanceFunction;
            protected PCARunner pca;
            protected EigenPairFilter filter;

            @Override
            protected void makeOptions(Parameterization config) {
                ObjectParameter filterP;
                ObjectParameter pcaP;
                super.makeOptions(config);
                ObjectParameter pcaDistanceFunctionP = new ObjectParameter(PCA_DISTANCE_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class);
                if (config.grab(pcaDistanceFunctionP)) {
                    this.pcaDistanceFunction = (DistanceFunction)pcaDistanceFunctionP.instantiateClass(config);
                }
                if (config.grab(pcaP = new ObjectParameter(PCARunner.Parameterizer.PCARUNNER_ID, (Class<?>)PCARunner.class, PCARunner.class))) {
                    this.pca = (PCARunner)pcaP.instantiateClass(config);
                }
                if (config.grab(filterP = new ObjectParameter(EigenPairFilter.PCA_EIGENPAIR_FILTER, (Class<?>)EigenPairFilter.class, PercentageEigenPairFilter.class))) {
                    this.filter = (EigenPairFilter)filterP.instantiateClass(config);
                }
            }
        }
    }
}

