/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.localpca;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.localpca.AbstractFilteredPCAIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="Knn Query Based Local PCA Preprocessor")
@Description(value="Materializes the local PCA and the locally weighted matrix of objects of a database. The PCA is based on k nearest neighbor queries.")
public class KNNQueryFilteredPCAIndex<NV extends NumberVector>
extends AbstractFilteredPCAIndex<NV> {
    private static final Logging LOG = Logging.getLogger(KNNQueryFilteredPCAIndex.class);
    private final KNNQuery<NV> knnQuery;
    private final int k;

    public KNNQueryFilteredPCAIndex(Relation<NV> relation, PCARunner pca, EigenPairFilter filter, KNNQuery<NV> knnQuery, int k) {
        super(relation, pca, filter);
        this.knnQuery = knnQuery;
        this.k = k;
        int dim = RelationUtil.dimensionality(relation);
        if (dim > 0 && k <= dim) {
            LOG.warning("PCA results with k < dim are meaningless. Choose k much larger than the dimensionality.");
        }
    }

    @Override
    protected KNNList objectsForPCA(DBIDRef id) {
        return this.knnQuery.getKNNForDBID(id, this.k);
    }

    @Override
    public String getLongName() {
        return "kNN-based local filtered PCA";
    }

    @Override
    public String getShortName() {
        return "kNNFilteredPCA";
    }

    @Override
    public Logging getLogger() {
        return LOG;
    }

    @Override
    public void logStatistics() {
    }

    public static class Factory<V extends NumberVector>
    extends AbstractFilteredPCAIndex.Factory<V> {
        private int k;

        public Factory(DistanceFunction<V> pcaDistanceFunction, PCARunner pca, EigenPairFilter filter, int k) {
            super(pcaDistanceFunction, pca, filter);
            this.k = k;
        }

        @Override
        public KNNQueryFilteredPCAIndex<V> instantiate(Relation<V> relation) {
            KNNQuery<V> knnquery = QueryUtil.getKNNQuery(relation, this.pcaDistanceFunction, this.k);
            return new KNNQueryFilteredPCAIndex<V>(relation, this.pca, this.filter, knnquery, this.k);
        }

        public static class Parameterizer<NV extends NumberVector>
        extends AbstractFilteredPCAIndex.Factory.Parameterizer<NV, KNNQueryFilteredPCAIndex<NV>> {
            public static final OptionID K_ID = new OptionID("localpca.k", "The number of nearest neighbors considered in the PCA. If this parameter is not set, k ist set to three times of the dimensionality of the database objects.");
            protected int k = 0;

            @Override
            protected void makeOptions(Parameterization config) {
                super.makeOptions(config);
                IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
                if (config.grab(kP)) {
                    this.k = kP.intValue();
                }
            }

            @Override
            protected Factory<NV> makeInstance() {
                return new Factory(this.pcaDistanceFunction, this.pca, this.filter, this.k);
            }
        }
    }
}

